/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition;

import adams.flow.condition.AbstractCondition;
import adams.flow.condition.AbstractScriptCondition;
import adams.flow.core.AdditionalOptionsHandler;
import adams.flow.core.AdditionalOptionsHandlerUtils;
import java.io.File;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jython
extends AbstractScriptCondition {
    private static final long serialVersionUID = -2562159780167388413L;
    protected transient AbstractCondition m_ConditionObject;
    protected Hashtable<String, String> m_AdditionalOptions;

    public String globalInfo() {
        return "A condition that uses the condition defined in an external Jython script.";
    }

    protected void initialize() {
        super.initialize();
        this.m_AdditionalOptions = new Hashtable();
    }

    public String scriptOptionsTipText() {
        return "The options for the Jython script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOption(String)' in the Jython actor.";
    }

    protected String loadScriptObject() {
        String result = null;
        try {
            this.m_ScriptObject = null;
            if (this.m_ScriptFile.isFile()) {
                this.m_ScriptObject = (AbstractCondition)adams.core.scripting.Jython.newInstance((File)this.m_ScriptFile, AbstractCondition.class);
                if (this.m_ScriptObject != null) {
                    if (!AdditionalOptionsHandlerUtils.setOptions((Object)this.m_ScriptObject, (String)this.m_ScriptOptions)) {
                        result = "Does not implement '" + AdditionalOptionsHandler.class.getName() + "': " + this.m_ScriptFile;
                    }
                } else {
                    result = "Failed to instantiate script '" + this.m_ScriptFile + "'!";
                }
            } else {
                result = "No script provided!";
            }
        }
        catch (Exception e) {
            this.m_ScriptObject = null;
            this.getSystemErr().printStackTrace((Throwable)e);
            result = "Failed to initialize Jython script '" + this.m_ScriptFile + "': " + e.toString();
        }
        return result;
    }

    protected String checkScriptObject() {
        this.m_ConditionObject = (AbstractCondition)this.m_ScriptObject;
        return null;
    }

    protected String performScriptTest() {
        return this.m_ConditionObject.getTestResult();
    }

    public void setAdditionalOptions(Hashtable<String, String> options) {
        this.m_AdditionalOptions = (Hashtable)options.clone();
    }

    public String getAdditionalOption(String name, String defValue) {
        if (this.m_AdditionalOptions.containsKey(name)) {
            return this.m_AdditionalOptions.get(name);
        }
        return defValue;
    }
}

