/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.base.BasePassword;
import adams.core.io.PlaceholderFile;
import adams.db.DatabaseConnection;
import adams.flow.sink.AbstractSink;
import java.util.Hashtable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.DatabaseSaver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WekaDatabaseWriter
extends AbstractSink {
    private static final long serialVersionUID = 7509908838736709270L;
    public static final String BACKUP_SAVER = "saver";
    protected String m_URL;
    protected String m_User;
    protected BasePassword m_Password;
    protected String m_TableName;
    protected boolean m_AutoKeyGeneration;
    protected boolean m_UseRelationNameAsTable;
    protected PlaceholderFile m_CustomPropsFile;
    protected DatabaseSaver m_Saver;

    public String globalInfo() {
        return "Actor for saving a weka.core.Instances object in a database.\nThe relation name of the incoming dataset can be used to replace the current filename (path and extension are kept).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("url", "URL", (Object)DatabaseConnection.getSingleton().getDefaultURL(), false);
        this.m_OptionManager.add("user", "user", (Object)DatabaseConnection.getSingleton().getDefaultUser(), false);
        this.m_OptionManager.add("password", "password", (Object)DatabaseConnection.getSingleton().getDefaultPassword(), false);
        this.m_OptionManager.add("table", "tableName", (Object)"weka");
        this.m_OptionManager.add("auto-key-generation", "autoKeyGeneration", (Object)false);
        this.m_OptionManager.add("use-relation-as-table", "useRelationNameAsTable", (Object)false);
        this.m_OptionManager.add("custom-props", "customPropsFile", (Object)new PlaceholderFile("."));
    }

    protected void reset() {
        super.reset();
        this.m_Saver = null;
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("user");
        String result = variable != null ? variable : this.m_User;
        result = result + "@";
        variable = this.getOptionManager().getVariableForProperty("URL");
        result = variable != null ? result + variable : result + this.m_URL;
        variable = this.getOptionManager().getVariableForProperty("customPropsFile");
        if (variable != null || !this.m_CustomPropsFile.isDirectory()) {
            result = result + " (custom props: ";
            result = variable != null ? result + variable : result + this.m_CustomPropsFile;
            result = result + ")";
        }
        return result;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_SAVER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Saver != null) {
            result.put(BACKUP_SAVER, this.m_Saver);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_SAVER)) {
            this.m_Saver = (DatabaseSaver)state.get(BACKUP_SAVER);
            state.remove(BACKUP_SAVER);
        }
        super.restoreState(state);
    }

    public void setURL(String value) {
        this.m_URL = value;
        this.reset();
    }

    public String getURL() {
        return this.m_URL;
    }

    public String URLTipText() {
        return "The JDBC URL of the database to query.";
    }

    public void setUser(String value) {
        this.m_User = value;
        this.reset();
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The user for connecting to the database.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
        this.reset();
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password for the database user.";
    }

    public void setTableName(String value) {
        this.m_TableName = value;
        this.reset();
    }

    public String getTableName() {
        return this.m_TableName;
    }

    public String tableNameTipText() {
        return "The name of the table to store the data in.";
    }

    public void setAutoKeyGeneration(boolean value) {
        this.m_AutoKeyGeneration = value;
        this.reset();
    }

    public boolean getAutoKeyGeneration() {
        return this.m_AutoKeyGeneration;
    }

    public String autoKeyGenerationTipText() {
        return "If set to true, a primary key is automatically generated.";
    }

    public void setUseRelationNameAsTable(boolean value) {
        this.m_UseRelationNameAsTable = value;
        this.reset();
    }

    public boolean getUseRelationNameAsTable() {
        return this.m_UseRelationNameAsTable;
    }

    public String useRelationNameAsTableTipText() {
        return "If set to true, the relation name is used as table name.";
    }

    public void setCustomPropsFile(PlaceholderFile value) {
        this.m_CustomPropsFile = value;
        this.reset();
    }

    public PlaceholderFile getCustomPropsFile() {
        return this.m_CustomPropsFile;
    }

    public String customPropsFileTipText() {
        return "Custom properties file to override the default database settings, eg, for accessing a different type of database; ignored if pointing to a directory.";
    }

    public Class[] accepts() {
        return new Class[]{Instances.class, Instance.class};
    }

    protected String doExecute() {
        Instances data;
        Instance inst;
        String result = null;
        if (this.m_InputToken.getPayload() instanceof Instance) {
            inst = (Instance)this.m_InputToken.getPayload();
            data = inst.dataset();
        } else {
            data = (Instances)this.m_InputToken.getPayload();
            inst = null;
        }
        try {
            if (this.m_Saver == null) {
                this.m_Saver = new DatabaseSaver();
                this.m_Saver.setUrl(this.m_URL);
                this.m_Saver.setUser(this.m_User);
                this.m_Saver.setPassword(this.m_Password.getValue());
                this.m_Saver.setTableName(this.m_TableName);
                this.m_Saver.setRelationForTableName(this.m_UseRelationNameAsTable);
                this.m_Saver.setAutoKeyGeneration(this.m_AutoKeyGeneration);
                if (!this.m_CustomPropsFile.isDirectory()) {
                    this.m_Saver.setCustomPropsFile(this.m_CustomPropsFile.getAbsoluteFile());
                }
                this.m_Saver.setInstances(data);
            }
            if (inst == null) {
                this.m_Saver.writeBatch();
            } else {
                this.m_Saver.writeIncremental(inst);
            }
        }
        catch (Exception e) {
            result = e.toString();
            this.getSystemErr().printStackTrace((Throwable)e);
        }
        return result;
    }

    public void wrapUp() {
        this.m_Saver = null;
        super.wrapUp();
    }
}

