/*
 * Decompiled with CFR 0.152.
 */
package adams.gui;

import adams.core.Index;
import adams.core.Range;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.gui.core.OptionHandlingFrame;
import adams.gui.visualization.instance.InstanceComparePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;

public class InstanceCompare
extends OptionHandlingFrame {
    private static final long serialVersionUID = -8575580776969822903L;
    protected InstanceComparePanel m_PanelCompare;
    protected PlaceholderFile m_FirstFile;
    protected Range m_FirstAttributeRange;
    protected Index m_FirstRowIndex;
    protected PlaceholderFile m_SecondFile;
    protected Range m_SecondAttributeRange;
    protected Index m_SecondRowIndex;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file1", "firstDataset", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("att-range1", "firstAttributeRange", (Object)"first-last");
        this.m_OptionManager.add("row-index1", "firstRowIndex", (Object)"");
        this.m_OptionManager.add("file2", "secondDataset", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("att-range2", "secondAttributeRange", (Object)"first-last");
        this.m_OptionManager.add("row-index2", "secondRowIndex", (Object)"");
    }

    protected void initialize() {
        super.initialize();
        this.m_FirstAttributeRange = new Range();
        this.m_FirstRowIndex = new Index();
        this.m_SecondAttributeRange = new Range();
        this.m_SecondRowIndex = new Index();
    }

    protected void initGUI() {
        super.initGUI();
        this.setTitle("Instance Compare");
        this.getContentPane().setLayout(new BorderLayout());
        this.m_PanelCompare = new InstanceComparePanel();
        this.getContentPane().add((Component)((Object)this.m_PanelCompare), "Center");
    }

    public void setFirstDataset(PlaceholderFile value) {
        this.m_FirstFile = value;
        this.reset();
    }

    public PlaceholderFile getFirstDataset() {
        return this.m_FirstFile;
    }

    public String firstDatasetTipText() {
        return "The first dataset in the comparison.";
    }

    public void setFirstAttributeRange(String value) {
        this.m_FirstAttributeRange.setRange(value);
        this.reset();
    }

    public String getFirstAttributeRange() {
        return this.m_FirstAttributeRange.getRange();
    }

    public String firstAttributeRangeTipText() {
        return "The range of attributes of the first dataset to use in the comparison.";
    }

    public void setFirstRowIndex(String value) {
        this.m_FirstRowIndex.setIndex(value);
        this.reset();
    }

    public String getFirstRowIndex() {
        return this.m_FirstRowIndex.getIndex();
    }

    public String firstRowIndexTipText() {
        return "The index of the attribute in the first dataset to use for matching the rows of the two datasets.";
    }

    public void setSecondDataset(PlaceholderFile value) {
        this.m_SecondFile = value;
        this.reset();
    }

    public PlaceholderFile getSecondDataset() {
        return this.m_SecondFile;
    }

    public String secondDatasetTipText() {
        return "The second dataset in the comparison.";
    }

    public void setSecondAttributeRange(String value) {
        this.m_SecondAttributeRange.setRange(value);
        this.reset();
    }

    public String getSecondAttributeRange() {
        return this.m_SecondAttributeRange.getRange();
    }

    public String secondAttributeRangeTipText() {
        return "The range of attributes of the second dataset to use in the comparison.";
    }

    public void setSecondRowIndex(String value) {
        this.m_SecondRowIndex.setIndex(value);
        this.reset();
    }

    public String getSecondRowIndex() {
        return this.m_SecondRowIndex.getIndex();
    }

    public String secondRowIndexTipText() {
        return "The index of the attribute in the second dataset to use for matching the rows of the two datasets.";
    }

    protected void beforeShow() {
        super.beforeShow();
        if (this.m_FirstFile.exists() && !this.m_FirstFile.isDirectory()) {
            this.m_PanelCompare.setFirstDataset((File)this.m_FirstFile);
            this.m_PanelCompare.setFirstAttributeRange(this.m_FirstAttributeRange.getRange());
            this.m_PanelCompare.setFirstRowIndex(this.m_FirstRowIndex.getIndex());
        } else {
            this.getSystemErr().println("1st file does not exist: " + this.m_FirstFile);
        }
        if (this.m_SecondFile.exists() && !this.m_SecondFile.isDirectory()) {
            this.m_PanelCompare.setSecondDataset((File)this.m_SecondFile);
            this.m_PanelCompare.setSecondAttributeRange(this.m_SecondAttributeRange.getRange());
            this.m_PanelCompare.setSecondRowIndex(this.m_SecondRowIndex.getIndex());
        } else {
            this.getSystemErr().println("2nd file does not exist: " + this.m_SecondFile);
        }
    }

    public static void main(String[] args) {
        InstanceCompare.runFrame(Environment.class, InstanceCompare.class, (String[])args);
    }
}

