/*
 * Decompiled with CFR 0.152.
 */
package adams.ml;

import adams.ml.Classifier;
import adams.ml.DataRow;
import adams.ml.Dataset;
import adams.ml.WekaData;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Evaluation;
import weka.classifiers.functions.GPD;
import weka.classifiers.meta.FilteredClassifier;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.supervised.attribute.PLSFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WekaClassifier
extends Classifier {
    protected Instances m_Instances = null;
    protected WekaData m_WekaData = null;
    protected weka.classifiers.Classifier m_Classifier;

    public void setInstances(Instances in) {
        this.m_Instances = in;
    }

    public void setDataset(WekaData wd) {
        this.m_WekaData = wd;
        this.m_Instances = null;
    }

    public void setDataset(Dataset ds) {
        this.m_WekaData = new WekaData(ds);
        this.m_Instances = null;
    }

    public void setClassifier(weka.classifiers.Classifier classifier) {
        this.m_Classifier = classifier;
    }

    public Evaluation crossValidate(int numFolds, int rnd) {
        if (this.m_Instances == null && this.m_WekaData != null) {
            this.m_Instances = this.m_WekaData.toInstances(new String[]{this.m_class});
        }
        try {
            Evaluation e = new Evaluation(this.m_Instances);
            e.crossValidateModel(this.m_Classifier, this.m_Instances, numFolds, new Random(rnd), new Object[0]);
            return e;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    Classifier.BuildResult build(String cls) {
        this.m_WekaData.setClass(cls);
        this.m_WekaData.setUseAllAttributes();
        if (this.m_Instances == null && this.m_WekaData != null) {
            this.m_Instances = this.m_WekaData.toInstances(new String[]{cls});
        }
        try {
            this.m_Classifier.buildClassifier(this.m_Instances);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Classifier.BuildResult((Classifier)this, "Fail:\n" + e.toString());
        }
        return new Classifier.BuildResult((Classifier)this, "Success\n" + this.m_Classifier.toString());
    }

    Classifier.BuildResult build(String[] srta, String classv) {
        this.m_WekaData.setAttributes(srta);
        return this.build(classv);
    }

    Classifier.BuildResult build(Vector<String> attributes, String classv) {
        return null;
    }

    Classifier.ClassificationResult classify(DataRow row) {
        Instance in = this.m_WekaData.DataRowToInstance(row);
        in.setDataset(this.m_Instances);
        try {
            double res = this.m_Classifier.classifyInstance(in);
            if (in.classAttribute().isNominal()) {
                return new Classifier.ClassificationResult((Classifier)this, "Success", Double.valueOf(res), in.classAttribute().value((int)res));
            }
            return new Classifier.ClassificationResult((Classifier)this, "Success", Double.valueOf(res));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Classifier.ClassificationResult((Classifier)this, "Fail:\n" + e.toString());
        }
    }

    public static void main(String[] args) {
        WekaData wd = new WekaData();
        wd.loadArff("/home/dale/fatty3.arff");
        System.err.println("loaded");
        wd.findArrays("(amplitude)-(\\d+)");
        System.err.println("found");
        System.err.println(wd.toString());
        WekaClassifier wc = new WekaClassifier();
        wc.setDataset(wd);
        FilteredClassifier c = new FilteredClassifier();
        c.setClassifier((weka.classifiers.Classifier)new GPD());
        PLSFilter f = new PLSFilter();
        f.setNumComponents(3);
        c.setFilter((Filter)f);
        wc.setClassifier((weka.classifiers.Classifier)c);
        Classifier.BuildResult br = wc.build("ref_dat.value");
        Evaluation e = wc.crossValidate(10, 1);
        System.out.println(e.toSummaryString("\nResults\n======\n", false));
        for (int i = 0; i < wd.count(); ++i) {
            DataRow d = wd.get(i);
            Classifier.ClassificationResult cr = wc.classify(d);
            System.err.println(cr.toString());
        }
    }
}

