/*
 * Decompiled with CFR 0.152.
 */
package adams.ml;

import adams.ml.BaseData;
import adams.ml.DataRow;
import adams.ml.Dataset;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WekaData
extends Dataset {
    protected Vector<String> m_attributes;
    protected String m_class = null;
    protected Boolean m_findArrays = false;
    protected ArrayFinder m_af = new ArrayFinder();
    public static final String ARRAY_REGEX = "(.+)\\[(\\d+)\\]";
    protected Hashtable<String, Hashtable<String, Integer>> m_Nominalise = new Hashtable();
    protected Instances m_header = null;

    public WekaData() {
    }

    public WekaData(Dataset ds) {
        this.m_header = null;
        this.use(ds);
    }

    public void setClass(String name) {
        this.m_class = name;
    }

    public void setFindArrays(Boolean b) {
        this.m_findArrays = b;
    }

    public void setFindArrays(String s) {
        this.m_af.reset(s);
        this.m_findArrays = s != null;
    }

    protected Vector<Attribute> generateAttributes(String key) {
        Vector<Attribute> va = new Vector<Attribute>();
        Dataset.Mapping mapping = (Dataset.Mapping)this.m_Mapping.get(key);
        if (mapping != null) {
            switch (mapping.m_type) {
                case NUMERIC: {
                    va.add(new Attribute(key));
                    return va;
                }
                case STRING: {
                    Hashtable<String, Integer> ht = this.m_Nominalise.get(key);
                    if (ht != null) {
                        FastVector f = new FastVector();
                        for (String nom : ht.keySet()) {
                            f.add((Object)nom);
                        }
                        va.add(new Attribute(key, (List)f));
                    } else {
                        va.add(new Attribute(key, (List)((FastVector)null)));
                    }
                    return va;
                }
                case ARRAY: {
                    switch (mapping.m_basetype) {
                        case NUMERIC: {
                            for (int i = 0; i < mapping.m_size; ++i) {
                                va.add(new Attribute(key + "[" + i + "]"));
                            }
                            return va;
                        }
                        case STRING: {
                            for (int i = 0; i < mapping.m_size; ++i) {
                                va.add(new Attribute(key + "[" + i + "]", (List)((FastVector)null)));
                            }
                            return va;
                        }
                    }
                    System.err.println("Other1");
                    return va;
                }
            }
            System.err.println("Other2");
            return va;
        }
        System.err.println("No Mapping for:" + key);
        return va;
    }

    public Vector<String> getAllAttributes() {
        Vector attss = (Vector)this.m_attributes.clone();
        if (this.m_class != null) {
            attss.add(this.m_class);
        }
        return attss;
    }

    protected Instances generateHeader() {
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        Vector<String> ats = this.getAllAttributes();
        for (int i = 0; i < ats.size(); ++i) {
            String key = ats.get(i);
            Vector<Attribute> v = this.generateAttributes(key);
            for (Attribute a : v) {
                atts.add(a);
            }
        }
        return new Instances("", atts, 0);
    }

    public Instances toInstances() {
        return this.toInstances(null);
    }

    public Instances toInstances(String[] requirePresent) {
        this.m_header = this.generateHeader();
        this.m_header.setRelationName(this.m_name);
        Instances newI = new Instances(this.m_header, 0);
        for (int row = 0; row < this.count(); ++row) {
            DataRow dr = this.get(row);
            boolean add = true;
            if (requirePresent != null) {
                for (int i = 0; i < requirePresent.length; ++i) {
                    Object bd = dr.getObject(requirePresent[i]);
                    if (bd != null) continue;
                    add = false;
                    break;
                }
            }
            if (!add) continue;
            Instance i = this.DataRowToInstance(dr);
            newI.add(i);
        }
        if (this.m_class != null) {
            newI.setClassIndex(newI.numAttributes() - 1);
        }
        if (this.m_findArrays.booleanValue()) {
            this.findArrays();
        }
        return newI;
    }

    protected Instance DataRowToInstance(DataRow dr) {
        Instances newI = new Instances(this.m_header, 0);
        DenseInstance di = new DenseInstance(this.m_header.numAttributes());
        Vector<String> ats = this.getAllAttributes();
        block13: for (int i = 0; i < ats.size(); ++i) {
            String key = ats.get(i);
            BaseData bd = dr.get(key);
            if (bd == null) continue;
            Dataset.Mapping mapping = (Dataset.Mapping)this.m_Mapping.get(key);
            if (mapping == null) {
                System.err.println("Unsure about:" + key);
                continue;
            }
            Object o = bd.getData();
            Attribute a = newI.attribute(key);
            switch (mapping.m_type) {
                case NUMERIC: {
                    if (!bd.isNumeric()) continue block13;
                    try {
                        Double val = Double.parseDouble(o.toString());
                        di.setValue(a, val.doubleValue());
                    }
                    catch (Exception e) {
                        System.err.println("Not a number");
                    }
                    continue block13;
                }
                case STRING: {
                    Hashtable<String, Integer> ht = this.m_Nominalise.get(key);
                    if (ht != null) {
                        if (ht.get(o.toString()) != null) {
                            di.setValue(a, o.toString());
                            continue block13;
                        }
                        System.err.println("trying to set nominal value when not in setup:" + o.toString());
                        continue block13;
                    }
                    di.setValue(a, o.toString());
                    continue block13;
                }
                case ARRAY: {
                    switch (mapping.m_basetype) {
                        case NUMERIC: {
                            Object ao;
                            int j;
                            if (bd.isArray()) {
                                for (j = 0; j < mapping.m_size; ++j) {
                                    if (j >= Array.getLength(o)) continue;
                                    ao = Array.get(o, j);
                                    a = newI.attribute(key + "[" + j + "]");
                                    if (!BaseData.isNumeric((Object)ao)) continue;
                                    try {
                                        Double val = Double.parseDouble(ao.toString());
                                        di.setValue(a, val.doubleValue());
                                        continue;
                                    }
                                    catch (Exception e) {
                                        System.err.println("Not a number");
                                    }
                                }
                                continue block13;
                            }
                            System.err.println("Not an array:" + key);
                            break;
                        }
                        case STRING: {
                            Object ao;
                            int j;
                            for (j = 0; j < mapping.m_size; ++j) {
                                if (j >= Array.getLength(o)) continue;
                                ao = Array.get(o, j);
                                a = newI.attribute(key + "[" + j + "]");
                                di.setValue(a, ao.toString());
                            }
                            continue block13;
                        }
                        default: {
                            System.err.println("Other1");
                            break;
                        }
                    }
                    continue block13;
                }
                default: {
                    System.err.println("Other2aaa");
                }
            }
        }
        return di;
    }

    public void setAttributes(String[] atts) {
        this.m_attributes = new Vector();
        if (atts != null) {
            for (int i = 0; i < atts.length; ++i) {
                if (atts[i] == null) continue;
                this.m_attributes.add(atts[i]);
            }
        }
    }

    public void setNominal(String key, String[] noms) {
        Hashtable<String, Integer> ht = new Hashtable<String, Integer>();
        for (int i = 0; i < noms.length; ++i) {
            ht.put(noms[i], i + 1);
        }
        this.m_Nominalise.put(key, ht);
        this.m_Mapping.put(key, new Dataset.Mapping((Dataset)this, BaseData.Type.STRING));
    }

    public void setNominalFromDataset(String key) {
        Hashtable<String, Integer> ht = new Hashtable<String, Integer>();
        int count = 0;
        for (int i = 0; i < this.count(); ++i) {
            String s;
            DataRow dr = this.get(i);
            BaseData bd = dr.get(key);
            if (bd == null || ht.get(s = bd.m_data.toString()) != null) continue;
            ht.put(s, ++count);
        }
        this.m_Nominalise.put(key, ht);
        this.m_Mapping.put(key, new Dataset.Mapping((Dataset)this, BaseData.Type.STRING));
    }

    public void setUseAllAttributes() {
        Hashtable<String, Boolean> ht = new Hashtable<String, Boolean>();
        for (int i = 0; i < this.count(); ++i) {
            DataRow dr = this.get(i);
            for (String s : dr.getKeys()) {
                ht.put(s, true);
            }
        }
        String[] arr = new String[ht.keySet().size()];
        int i = 0;
        for (String s : ht.keySet()) {
            if (this.m_class != null && (this.m_class == null || s.equals(this.m_class))) continue;
            arr[i++] = s;
        }
        this.setAttributes(arr);
    }

    protected void findArrays() {
        this.findArrays(ARRAY_REGEX);
    }

    protected void setArrayFinderFromInstancesHeader() {
        System.err.println("start setup af");
        Instances in = this.m_header;
        for (int i = 0; i < in.numAttributes(); ++i) {
            Integer min_index;
            Integer index;
            Attribute a = in.attribute(i);
            String s = a.name();
            this.m_af.m_isArray.put(s, false);
            Matcher matcher = this.m_af.m_pattern.matcher(s);
            if (!matcher.matches()) continue;
            this.m_af.m_isArray.put(s, true);
            String name = matcher.group(1);
            String index_s = matcher.group(2);
            try {
                index = Integer.parseInt(index_s);
            }
            catch (Exception e) {
                System.err.println("Funny looking index:" + name + "," + index_s);
                continue;
            }
            Hashtable<Integer, String> indexmapping = this.m_af.m_attributemapping.get(name);
            Vector<String> vs = this.m_af.m_arrayCompress.get(name);
            if (indexmapping == null) {
                vs = new Vector();
                this.m_af.m_arrayCompress.put(name, vs);
                indexmapping = new Hashtable();
                this.m_af.m_attributemapping.put(name, indexmapping);
            }
            vs.add(s);
            indexmapping.put(index, s);
            this.m_af.m_remove.put(s, true);
            Integer max_index = this.m_af.m_maxindex.get(name);
            if (max_index == null || max_index != null && max_index <= index) {
                this.m_af.m_maxindex.put(name, index);
                if (this.m_af.httype.get(name) == null) {
                    if (a.isNumeric()) {
                        this.m_af.httype.put(name, BaseData.Type.NUMERIC);
                    } else {
                        this.m_af.httype.put(name, BaseData.Type.STRING);
                    }
                }
            }
            if ((min_index = this.m_af.m_minindex.get(name)) != null && (min_index == null || min_index < index)) continue;
            this.m_af.m_minindex.put(name, index);
        }
        for (String key : this.m_af.httype.keySet()) {
            this.setType(key, this.m_af.httype.get(key), this.m_af.m_maxindex.get(key) - this.m_af.m_minindex.get(key) + 1);
        }
        this.m_af.m_headergenerated = true;
        System.err.println("complete setup af");
    }

    protected void findArrays(DataRow dr) {
        ArrayFinder af = this.m_af;
        if (!this.m_af.m_headergenerated) {
            this.setArrayFinderFromInstancesHeader();
        }
        block4: for (String s : af.m_maxindex.keySet()) {
            BaseData.Type tp = af.httype.get(s);
            if (tp == null) {
                System.err.println("Problem with type for:" + s);
                continue;
            }
            switch (tp) {
                case NUMERIC: {
                    Object o2;
                    String attname;
                    double[] arr;
                    int max = this.m_af.m_maxindex.get(s);
                    int min = this.m_af.m_minindex.get(s);
                    Hashtable<Integer, String> indexmapping = this.m_af.m_attributemapping.get(s);
                    if (this.m_af.m_compress && indexmapping.size() != max - min + 1) {
                        Vector<String> vs = this.m_af.m_arrayCompress.get(s);
                        arr = new double[vs.size()];
                        for (int i = 0; i < arr.length; ++i) {
                            attname = vs.get(i);
                            o2 = dr.getObject(attname);
                            if (o2 == null) {
                                o2 = Double.NaN;
                            }
                            if (o2 instanceof Number) {
                                arr[i] = ((Number)o2).doubleValue();
                                continue;
                            }
                            if (!BaseData.isNumeric((Object)o2)) continue;
                            arr[i] = Double.parseDouble(o2.toString());
                        }
                    } else {
                        arr = new double[max - min + 1];
                        for (Integer in : indexmapping.keySet()) {
                            attname = indexmapping.get(in);
                            o2 = dr.getObject(attname);
                            if (o2 == null) {
                                o2 = Double.NaN;
                            }
                            if (o2 instanceof Number) {
                                arr[in.intValue() - min] = ((Number)o2).doubleValue();
                                continue;
                            }
                            if (!BaseData.isNumeric((Object)o2)) continue;
                            arr[in.intValue() - min] = Double.parseDouble(o2.toString());
                        }
                    }
                    dr.set(s, (Object)arr);
                    continue block4;
                }
                case STRING: {
                    int max = this.m_af.m_maxindex.get(s);
                    int min = this.m_af.m_minindex.get(s);
                    String[] arr2 = new String[max - min + 1];
                    Hashtable<Integer, String> indexmapping = this.m_af.m_attributemapping.get(s);
                    for (Integer in : indexmapping.keySet()) {
                        String attname = indexmapping.get(in);
                        Object o2 = dr.getObject(attname);
                        if (o2 == null) continue;
                        arr2[in.intValue() - min] = o2.toString();
                    }
                    dr.set(s, (Object)arr2);
                    continue block4;
                }
            }
            System.err.println("aProblem with type for:" + s);
        }
        for (int i = 0; i < this.count(); ++i) {
            for (String key : af.m_remove.keySet()) {
                dr.m_Data.remove(key);
            }
        }
    }

    protected void findArrays(String regex) {
        System.err.println("start fa");
        this.m_af.reset(regex);
        for (int i = 0; i < this.count(); ++i) {
            this.findArrays(this.get(i));
        }
        System.err.println("complete fa");
    }

    public DataRow instanceToDataRow(Instance in) {
        DataRow dr = new DataRow();
        for (int j = 0; j < in.numAttributes(); ++j) {
            Attribute att = in.attribute(j);
            if (Double.isNaN(in.value(att))) continue;
            if (att.type() == 1 || att.type() == 2) {
                dr.set(att.name(), (Object)in.stringValue(att));
                continue;
            }
            if (att.type() != 0) continue;
            dr.set(att.name(), (Object)in.value(att));
        }
        if (this.m_findArrays.booleanValue()) {
            this.findArrays(dr);
        }
        return dr;
    }

    public boolean loadArff(String filename, boolean qad) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            Instances data = new Instances((Reader)reader);
            reader.close();
            data.setClassIndex(data.numAttributes() - 1);
            if (qad) {
                this.instancesToDatasetNumericArray(data);
            } else {
                this.instancesToDataset(data);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean loadArff(String filename) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            Instances data = new Instances((Reader)reader);
            reader.close();
            data.setClassIndex(data.numAttributes() - 1);
            this.instancesToDataset(data);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void instancesToDatasetNumericArray(Instances insts) {
        this.empty();
        this.m_header = new Instances(insts, 0);
        this.setName(insts.relationName());
        for (int i = 0; i < insts.numInstances(); ++i) {
            DataRow dr = new DataRow();
            Instance in = insts.get(i);
            double[] arr = in.toDoubleArray();
            double[] arr2 = new double[arr.length - 1];
            System.arraycopy(arr, 0, arr2, 0, arr.length - 1);
            dr.set("attributes", (Object)arr2);
            dr.set(in.attribute(arr.length - 1).name(), (Object)in.value(arr.length - 1));
            this.add(dr);
        }
    }

    public void instancesToDataset(Instances insts) {
        this.empty();
        this.m_header = new Instances(insts, 0);
        Vector<String> nominalise = new Vector<String>();
        for (int j = 0; j < insts.numAttributes(); ++j) {
            Attribute att = insts.attribute(j);
            if (att.type() == 1 || att.type() == 2) {
                this.setType(att.name(), BaseData.Type.STRING);
                if (att.type() != 1) continue;
                nominalise.add(att.name());
                continue;
            }
            if (att.type() != 0) continue;
            this.setType(att.name(), BaseData.Type.NUMERIC);
        }
        this.setName(insts.relationName());
        for (int i = 0; i < insts.numInstances(); ++i) {
            DataRow dr = new DataRow();
            Instance in = insts.get(i);
            for (int j = 0; j < in.numAttributes(); ++j) {
                Attribute att = in.attribute(j);
                if (Double.isNaN(in.value(att))) continue;
                if (att.type() == 1 || att.type() == 2) {
                    dr.set(att.name(), (Object)in.stringValue(att));
                    if (att.type() != 1) continue;
                    nominalise.add(att.name());
                    continue;
                }
                if (att.type() != 0) continue;
                dr.set(att.name(), (Object)in.value(att));
            }
            this.add(dr);
        }
        String[] arr = new String[insts.numAttributes()];
        for (int j = 0; j < insts.numAttributes(); ++j) {
            Attribute att = insts.attribute(j);
            if (insts.classIndex() == j) {
                this.setClass(att.name());
                continue;
            }
            arr[j] = att.name();
        }
        if (insts.classIndex() == -1) {
            this.setClass(null);
        }
        this.setAttributes(arr);
        for (String s : nominalise) {
            this.setNominalFromDataset(s);
        }
    }

    public static void main(String[] args) {
        Dataset ds = new Dataset("Test");
        DataRow dr = new DataRow();
        dr.set("id", (Object)"a1");
        dr.set("fruit", (Object)"banana");
        double[] arr = new double[10];
        for (int i = 0; i < 10; ++i) {
            arr[i] = (double)i * 0.99;
        }
        dr.set("spectrum", (Object)arr);
        ds.add(dr);
        dr = new DataRow();
        dr.set("id", (Object)"a2");
        dr.set("fruit", (Object)"tomao");
        int[] arr1 = new int[10];
        for (int i = 0; i < 10; ++i) {
            arr1[i] = 1 + i;
        }
        dr.set("spectrum", (Object)arr1);
        ds.add(dr);
        ds.autoID("auto_id");
        WekaData wc = new WekaData(ds);
        DataRow dr2 = new DataRow();
        dr.set("id", (Object)"a1");
        dr.set("fruit", (Object)"banana");
        double[] arr2 = new double[10];
        for (int i = 0; i < 10; ++i) {
            arr[i] = (double)i * 0.99;
        }
        dr.set("spectrum", (Object)arr2);
        wc.setClass("fruit");
        wc.setNominalFromDataset("fruit");
        wc.setAttributes(new String[]{"auto_id", "id", "spectrum"});
        Instances in = wc.toInstances();
        in.setClassIndex(in.numAttributes() - 1);
        System.err.println(in.toString());
        WekaData wc2 = new WekaData();
        wc2.instancesToDataset(in);
        System.err.println(wc2.toString());
        System.err.println("now find arrays");
        wc2.findArrays(ARRAY_REGEX);
        wc2.setAttributes(new String[]{"auto_id", "id", "spectrum"});
        Instances in2 = wc2.toInstances();
        System.err.println(in2.toString());
        System.err.println(wc2.toString());
    }

    public class ArrayFinder {
        public String m_regex = null;
        Hashtable<String, Boolean> m_isArray = new Hashtable();
        Hashtable<String, Integer> m_maxindex = new Hashtable();
        Hashtable<String, Integer> m_minindex = new Hashtable();
        Hashtable<String, Hashtable<Integer, String>> m_attributemapping = new Hashtable();
        Hashtable<String, Vector<String>> m_arrayCompress = new Hashtable();
        Hashtable<String, BaseData.Type> httype = new Hashtable();
        Hashtable<String, Boolean> m_remove = new Hashtable();
        Pattern m_pattern = null;
        boolean m_compress = true;
        boolean m_headergenerated = false;

        public void reset() {
            this.m_isArray = new Hashtable();
            this.m_maxindex = new Hashtable();
            this.m_minindex = new Hashtable();
            this.m_attributemapping = new Hashtable();
            this.m_arrayCompress = new Hashtable();
            this.httype = new Hashtable();
            this.m_remove = new Hashtable();
            this.m_compress = true;
        }

        public void reset(String regex) {
            if (!regex.equals(this.m_regex)) {
                this.reset();
                this.m_regex = regex;
                this.m_pattern = Pattern.compile(regex);
                this.m_headergenerated = false;
            }
        }
    }
}

