/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import JSci.maths.wavelet.IllegalScalingException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.meta.Vote;
import weka.classifiers.rules.ZeroR;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.MultiFilter;
import weka.filters.unsupervised.attribute.Remove;
import weka.filters.unsupervised.instance.RemoveInstancesWithMissingValue;

public class SubsetEnsemble
extends RandomizableSingleClassifierEnhancer {
    private static final long serialVersionUID = -7637300579884789439L;
    protected Classifier[] m_Classifiers;
    protected int m_NumExecutionSlots = 1;
    protected int m_CombinationRule = 1;
    protected int m_NumRandomFeatures = 0;
    protected transient ThreadPoolExecutor m_ExecutorPool;
    protected int m_Completed;
    protected int m_Failed;
    protected Instances m_Data;
    protected Instances m_Header;
    protected ZeroR m_BackupModel;

    public String globalInfo() {
        return "Generates an ensemble using the following approach:\n- for each attribute apart from class attribute do:\n  * create new dataset with only this feature and the class attribute\n  * remove all instances that contain a missing value\n  * if no instances left in subset, don't build a classifier for this feature\n  * if at least 1 instance is left in subset, build base classifier with it\nIf no classifier gets built at all, use ZeroR as backup model, built on the full dataset.\nIn addition to the default feature for a subset, a number of random features can be added to the subset before the classifier is trained.\nAt prediction time, the Vote meta-classifier (using the pre-built classifiers) is used to determing the class probabilities or regression value.";
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tNumber of execution slots.\n\t(default: 1 - i.e. no parallelism)", "num-slots", 1, "-num-slots <num>"));
        result.addElement(new Option("\tThe combination rule to use\n\t(default: AVG)", "combination-rule", 1, "-combination-rule " + Tag.toOptionList((Tag[])Vote.TAGS_RULES)));
        result.addElement(new Option("\tNumber of random features to use in addition.\n\t(default: 0)", "num-random", 1, "-num-random <num>"));
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"num-slots", (String[])options);
        if (tmpStr.length() != 0) {
            this.setNumExecutionSlots(Integer.parseInt(tmpStr));
        } else {
            this.setNumExecutionSlots(1);
        }
        tmpStr = Utils.getOption((String)"combination-rule", (String[])options);
        if (tmpStr.length() != 0) {
            this.setCombinationRule(new SelectedTag(tmpStr, Vote.TAGS_RULES));
        } else {
            this.setCombinationRule(new SelectedTag(1, Vote.TAGS_RULES));
        }
        tmpStr = Utils.getOption((String)"num-random", (String[])options);
        if (tmpStr.length() != 0) {
            this.setNumRandomFeatures(Integer.parseInt(tmpStr));
        } else {
            this.setNumRandomFeatures(0);
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-num-slots");
        result.add("" + this.getNumExecutionSlots());
        result.add("-combination-rule");
        result.add("" + this.getCombinationRule());
        result.add("-num-random");
        result.add("" + this.getNumRandomFeatures());
        result.addAll(Arrays.asList(super.getOptions()));
        return result.toArray(new String[result.size()]);
    }

    public void setNumExecutionSlots(int value) {
        if (value >= 1) {
            this.m_NumExecutionSlots = value;
        } else {
            System.err.println("Number of execution slots must be >= 1");
        }
    }

    public int getNumExecutionSlots() {
        return this.m_NumExecutionSlots;
    }

    public String numExecutionSlotsTipText() {
        return "The number of execution slots (threads) to use for constructing the ensemble.";
    }

    public void setCombinationRule(SelectedTag value) {
        if (value.getTags() == Vote.TAGS_RULES) {
            this.m_CombinationRule = value.getSelectedTag().getID();
        }
    }

    public SelectedTag getCombinationRule() {
        return new SelectedTag(this.m_CombinationRule, Vote.TAGS_RULES);
    }

    public String combinationRuleTipText() {
        return "The combination rule used.";
    }

    public void setNumRandomFeatures(int value) {
        if (value >= 0) {
            this.m_NumRandomFeatures = value;
        } else {
            System.err.println("Number of additional random features must be >= 0");
        }
    }

    public int getNumRandomFeatures() {
        return this.m_NumRandomFeatures;
    }

    public String numRandomFeaturesTipText() {
        return "The number of additional random features to use.";
    }

    protected void startExecutorPool() {
        if (this.m_ExecutorPool != null) {
            this.m_ExecutorPool.shutdownNow();
        }
        this.m_ExecutorPool = new ThreadPoolExecutor(this.m_NumExecutionSlots, this.m_NumExecutionSlots, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    private synchronized void block(boolean wait) {
        if (wait) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            ((Object)((Object)this)).notifyAll();
        }
    }

    protected synchronized void buildClassifiers() throws Exception {
        Random rand = new Random(this.m_Seed);
        for (int i = 0; i < this.m_Classifiers.length; ++i) {
            final int index = i;
            final int seed = rand.nextInt();
            if (this.m_Debug) {
                System.out.print("Training classifier (" + (i + 1) + ")");
            }
            Runnable newTask = new Runnable(){

                public void run() {
                    try {
                        Instances train = SubsetEnsemble.this.getTrainingSet(index, seed);
                        if (train.numInstances() > 0) {
                            FilteredClassifier fc = new FilteredClassifier();
                            fc.setFilter(SubsetEnsemble.this.getFilter(index, seed, false));
                            fc.setClassifier(SubsetEnsemble.this.m_Classifiers[index]);
                            fc.buildClassifier(SubsetEnsemble.this.m_Data);
                            SubsetEnsemble.this.m_Classifiers[index] = fc;
                        } else {
                            SubsetEnsemble.this.m_Classifiers[index] = null;
                        }
                        SubsetEnsemble.this.completedClassifier(index, true);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        SubsetEnsemble.this.completedClassifier(index, false);
                    }
                }
            };
            this.m_ExecutorPool.execute(newTask);
        }
        if (this.m_Completed + this.m_Failed < this.m_Classifiers.length) {
            this.block(true);
        }
    }

    protected synchronized void completedClassifier(int index, boolean success) {
        if (!success) {
            ++this.m_Failed;
            if (this.m_Debug) {
                System.err.println("Building of classifier " + index + " failed!");
            }
        } else {
            ++this.m_Completed;
        }
        if (this.m_Completed + this.m_Failed == this.m_Classifiers.length) {
            if (this.m_Failed > 0 && this.m_Debug) {
                System.err.println("Problem building classifiers - some iterations failed.");
            }
            this.m_ExecutorPool.shutdown();
            this.block(false);
            this.m_Data = null;
        }
    }

    protected int getActualIndex(int index) throws Exception {
        int result = -1;
        int count = 0;
        for (int i = 0; i < this.m_Header.numAttributes(); ++i) {
            if (i == this.m_Header.classIndex()) continue;
            if (count == index) {
                result = i;
                break;
            }
            ++count;
        }
        if (result == -1) {
            throw new IllegalScalingException("Actual attribute index for index " + index + " could not be determined!");
        }
        return result;
    }

    protected Filter getFilter(int index, int seed, boolean withMissing) throws Exception {
        Remove result;
        int i;
        int actualIndex = this.getActualIndex(index);
        HashSet<Integer> features = new HashSet<Integer>();
        features.add(actualIndex);
        features.add(this.m_Data.classIndex());
        if (this.m_NumRandomFeatures > 0) {
            int numRandomFeatures = Math.min(this.m_NumRandomFeatures, this.m_Data.numAttributes() - 2);
            Random rand = new Random(seed);
            while (features.size() < numRandomFeatures) {
                i = rand.nextInt(this.m_Data.numAttributes());
                features.add(i);
            }
        }
        int[] indices = new int[features.size()];
        i = 0;
        for (Integer idx : features) {
            indices[i] = idx;
            ++i;
        }
        Arrays.sort(indices);
        Remove remove = new Remove();
        remove.setAttributeIndicesArray(indices);
        remove.setInvertSelection(true);
        if (withMissing) {
            RemoveInstancesWithMissingValue missing = new RemoveInstancesWithMissingValue();
            result = new MultiFilter();
            ((MultiFilter)result).setFilters(new Filter[]{remove, missing});
        } else {
            result = remove;
        }
        return result;
    }

    protected Instances getTrainingSet(int index, int seed) throws Exception {
        Filter filter = this.getFilter(index, seed, true);
        filter.setInputFormat(this.m_Data);
        Instances result = Filter.useFilter((Instances)this.m_Data, (Filter)filter);
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_Data = new Instances(data);
        this.m_Data.deleteWithMissingClass();
        this.m_Header = new Instances(this.m_Data, 0);
        if (this.m_Classifier == null) {
            throw new Exception("A base classifier has not been specified!");
        }
        this.m_Classifiers = AbstractClassifier.makeCopies((Classifier)this.m_Classifier, (int)(this.m_Data.numAttributes() - 1));
        this.startExecutorPool();
        this.m_Completed = 0;
        this.m_Failed = 0;
        this.m_BackupModel = new ZeroR();
        this.m_BackupModel.buildClassifier(this.m_Data);
        this.buildClassifiers();
    }

    protected Classifier constructEnsemble(Instance instance) {
        Object result;
        Vector<Classifier> classifiers = new Vector<Classifier>();
        int count = 0;
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (i == instance.classIndex() || instance.isMissing(i) || this.m_Classifiers[count] == null) continue;
            classifiers.add(this.m_Classifiers[count]);
            ++count;
        }
        if (classifiers.size() > 1) {
            result = new Vote();
            result.setCombinationRule(this.getCombinationRule());
            result.setClassifiers(classifiers.toArray(new Classifier[classifiers.size()]));
        } else {
            result = classifiers.size() == 1 ? (Classifier)classifiers.get(0) : this.m_BackupModel;
        }
        return result;
    }

    public double classifyInstance(Instance instance) throws Exception {
        return this.constructEnsemble(instance).classifyInstance(instance);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        return this.constructEnsemble(instance).distributionForInstance(instance);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.m_BackupModel == null) {
            result.append("No model built yet!");
        } else {
            result.append("--> Backup model\n");
            result.append(this.m_BackupModel.toString());
            result.append("\n");
            for (int i = 0; i < this.m_Classifiers.length; ++i) {
                try {
                    result.append("\n");
                    int actIndex = this.getActualIndex(i);
                    result.append("--> Classifier #" + (i + 1) + " (for attribute #" + (actIndex + 1) + "):\n");
                    if (this.m_Classifiers[i] == null) {
                        result.append("No model built - no useful data available");
                    } else {
                        result.append(this.m_Classifiers[i].toString());
                    }
                    result.append("\n");
                    continue;
                }
                catch (Exception e) {
                    result.append("Classifier #" + (i + 1) + ": skipped due to error\n");
                }
            }
        }
        return result.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 2991 $");
    }

    public static void main(String[] args) {
        SubsetEnsemble.runClassifier((Classifier)new SubsetEnsemble(), (String[])args);
    }
}

