/*
 * Decompiled with CFR 0.152.
 */
package weka.core.setupgenerator;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Option;
import weka.core.Utils;
import weka.core.setupgenerator.AbstractParameter;

public class ListParameter
extends AbstractParameter {
    private static final long serialVersionUID = 1415901739037349037L;
    protected String[] m_List = new String[0];

    public String globalInfo() {
        return "Container class defining the search parameters for a particular property.\nOnly the specified list values are used.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm);
        }
        result.addElement(new Option("\tThe list of explicit values to use (blank-separated list).\n\t(default: none)", "list", 1, "-list <values>"));
        return result.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-list");
        result.add("" + this.getList());
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"list", (String[])options);
        if (tmpStr.length() != 0) {
            this.setList(tmpStr);
        } else {
            this.setList("");
        }
        super.setOptions(options);
    }

    public String listTipText() {
        return "The blank-separated list of values to use.";
    }

    public String getList() {
        return Utils.joinOptions((String[])this.m_List);
    }

    public void setList(String value) {
        if (value.length() > 0) {
            try {
                this.m_List = Utils.splitOptions((String)value);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_List = new String[0];
            }
        } else {
            this.m_List = new String[0];
        }
    }

    public String toString() {
        String result = super.toString();
        result = result + ", list: " + this.getList();
        return result;
    }
}

