/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.experiment.InstanceQuery;
import weka.gui.Logger;
import weka.gui.SysErrLog;
import weka.gui.explorer.Explorer;
import weka.gui.sql.SqlViewer;

public class SqlPanel
extends JPanel
implements Explorer.ExplorerPanel,
Explorer.LogHandler {
    private static final long serialVersionUID = 2926260895970369406L;
    protected Explorer m_Explorer = null;
    protected PropertyChangeSupport m_Support = new PropertyChangeSupport(this);
    protected Logger m_Log = new SysErrLog();
    protected SqlViewer m_Viewer;
    protected JPanel m_PanelButtons;
    protected JButton m_ButtonLoad = new JButton("Load data");
    protected JLabel m_LabelQuery = new JLabel("");

    public SqlPanel() {
        this.initGUI();
    }

    protected void initGUI() {
        this.setLayout(new BorderLayout());
        this.m_Viewer = new SqlViewer(null);
        this.add((Component)this.m_Viewer, "Center");
        JPanel panel2 = new JPanel(new BorderLayout());
        this.add((Component)panel2, "South");
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel2.add((Component)panel, "East");
        this.m_ButtonLoad.setMnemonic('L');
        panel.add(this.m_ButtonLoad);
        this.m_ButtonLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SqlPanel.this.m_Support.firePropertyChange("", null, null);
            }
        });
        panel = new JPanel(new FlowLayout());
        panel2.add((Component)panel, "Center");
        panel.add(this.m_LabelQuery);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                try {
                    SqlPanel.this.m_Log.statusMessage("Querying database...");
                    SqlPanel.this.m_Log.logMessage("SQL query: URL=" + SqlPanel.this.m_Viewer.getURL() + ", User=" + SqlPanel.this.m_Viewer.getUser() + ", Password=" + SqlPanel.this.m_Viewer.getPassword().replaceAll(".*", "*") + ", Query=" + SqlPanel.this.m_Viewer.getQuery());
                    InstanceQuery query = new InstanceQuery();
                    query.setDatabaseURL(SqlPanel.this.m_Viewer.getURL());
                    query.setUsername(SqlPanel.this.m_Viewer.getUser());
                    query.setPassword(SqlPanel.this.m_Viewer.getPassword());
                    Instances data = query.retrieveInstances(SqlPanel.this.m_Viewer.getQuery());
                    SqlPanel.this.getExplorer().getPreprocessPanel().setInstances(data);
                    SqlPanel.this.m_Log.logMessage("SQL query returned " + data.numInstances() + " rows and " + data.numAttributes() + " columns");
                    SqlPanel.this.m_Log.statusMessage("Database query finished and data loaded.");
                }
                catch (Exception ex) {
                    SqlPanel.this.m_Log.logMessage("Exception encountered: " + ex);
                    ex.printStackTrace();
                }
            }
        });
    }

    public void setExplorer(Explorer parent) {
        this.m_Explorer = parent;
    }

    public Explorer getExplorer() {
        return this.m_Explorer;
    }

    public String getTabTitle() {
        return "SQL";
    }

    public String getTabTitleToolTip() {
        return "Retrieving data from databases";
    }

    public void setInstances(Instances inst) {
    }

    public void setLog(Logger newLog) {
        this.m_Log = newLog;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.removePropertyChangeListener(l);
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame("Weka Explorer: SQL");
            jf.getContentPane().setLayout(new BorderLayout());
            SqlPanel sp = new SqlPanel();
            jf.getContentPane().add((Component)sp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setSize(800, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

