/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Range;
import adams.core.io.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class SpreadSheetSubset
extends AbstractTransformer {
    private static final long serialVersionUID = -253714973019682939L;
    protected Range m_Rows;
    protected Range m_Columns;

    public String globalInfo() {
        return "Extracts a subset of rows/columns from a spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "rows", (Object)"first-last");
        this.m_OptionManager.add("col", "columns", (Object)"first-last");
    }

    protected void initialize() {
        super.initialize();
        this.m_Rows = new Range();
        this.m_Columns = new Range();
    }

    public String getQuickInfo() {
        String variableRow = this.getOptionManager().getVariableForProperty("rows");
        String variableCol = this.getOptionManager().getVariableForProperty("columns");
        String result = "rows: ";
        result = variableRow != null ? result + variableRow : result + this.m_Rows.getRange();
        result = result + "/";
        result = result + "cols: ";
        result = variableCol != null ? result + variableCol : result + this.m_Columns.getRange();
        return result;
    }

    public void setRows(String value) {
        this.m_Rows.setRange(value);
        this.reset();
    }

    public String getRows() {
        return this.m_Rows.getRange();
    }

    public String rowsTipText() {
        return "The rows of the subset to retrieve; " + this.m_Rows.getExample();
    }

    public void setColumns(String value) {
        this.m_Columns.setRange(value);
        this.reset();
    }

    public String getColumns() {
        return this.m_Columns.getRange();
    }

    public String columnsTipText() {
        return "The columns of the subset to retrieve; " + this.m_Columns.getExample();
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_Rows.setMax(sheet.getRowCount());
        this.m_Columns.setMax(sheet.getColumnCount());
        int[] rows = this.m_Rows.getIntIndices();
        int[] cols = this.m_Columns.getIntIndices();
        if (cols.length == 0) {
            result = "No columns selected!";
        } else {
            int i;
            SpreadSheet subset = new SpreadSheet();
            for (i = 0; i < cols.length; ++i) {
                subset.getHeaderRow().addCell("" + (i + 1)).setContent(sheet.getHeaderRow().getCell(cols[i]).getContent());
            }
            for (int n = 0; n < rows.length; ++n) {
                SpreadSheet.Row row = sheet.getRow(rows[n]);
                SpreadSheet.Row subrow = subset.addRow("" + subset.getRowCount());
                for (i = 0; i < cols.length; ++i) {
                    subrow.addCell("" + (i + 1)).setContent(row.getCell(cols[i]).getContent());
                }
            }
            this.m_OutputToken = new Token((Object)subset);
        }
        return result;
    }
}

