/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.Bzip2Utils;
import adams.flow.transformer.AbstractSingleDecompress;
import java.io.File;

public class UnBzip2
extends AbstractSingleDecompress {
    private static final long serialVersionUID = 1302879683785529480L;

    public String globalInfo() {
        return "Decompresses an archive that was compressed with bzip2. It is assumed, that the file ends with .bz2. If that is not the case, an alternative filename has to be provided.\nThe filename of the generated output filename is then broadcasted.";
    }

    public String useAlternativeOutputDirTipText() {
        return "By default the compressed file will be uncompressed at the same location as the archive with the .bz2 extension; use this option to enabled the selection of a different output directory.";
    }

    public String alternativeFilenameTipText() {
        return "The alternative filename to use, instead of the one from the input file with the .bz2 extension removed.";
    }

    protected String getDefaultExtension() {
        return ".bz2";
    }

    protected String decompress(File inFile, File outFile) {
        return Bzip2Utils.decompress(inFile, this.m_BufferSize, outFile);
    }
}

