/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.M5P;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.RemoveMisclassified;

public class RemoveMisclassifiedTest
extends AbstractFilterTest {
    public RemoveMisclassifiedTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances.setClassIndex(1);
        int i = 0;
        while (i < this.m_Instances.numAttributes()) {
            if (!this.m_Instances.attribute(i).isNominal() && !this.m_Instances.attribute(i).isNumeric()) {
                this.m_Instances.deleteAttributeAt(i);
                continue;
            }
            ++i;
        }
    }

    public Filter getFilter() {
        return this.getFilter(true);
    }

    protected Filter getFilter(boolean nominal) {
        RemoveMisclassified f = new RemoveMisclassified();
        if (nominal) {
            f.setClassifier((Classifier)new J48());
        } else {
            f.setClassifier((Classifier)new M5P());
        }
        if (!nominal) {
            f.setThreshold(2.0);
        }
        return f;
    }

    public void testNominal() {
        this.m_Filter = this.getFilter(true);
        this.m_Instances.setClassIndex(0);
        Instances result = this.useFilter();
        RemoveMisclassifiedTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
    }

    public void testNumeric() {
        this.m_Filter = this.getFilter(false);
        this.m_Instances.setClassIndex(1);
        Instances result = this.useFilter();
        RemoveMisclassifiedTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
    }

    public void testInverting() {
        this.m_Filter = this.getFilter();
        this.m_Instances.setClassIndex(0);
        Instances result = this.useFilter();
        this.m_Filter = this.getFilter();
        ((RemoveMisclassified)this.m_Filter).setInvert(true);
        this.m_Instances.setClassIndex(0);
        Instances resultInv = this.useFilter();
        RemoveMisclassifiedTest.assertEquals((int)this.m_Instances.numInstances(), (int)(result.numInstances() + resultInv.numInstances()));
    }

    public static Test suite() {
        return new TestSuite(RemoveMisclassifiedTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RemoveMisclassifiedTest.suite());
    }
}

