/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.print;

import adams.core.annotation.MixedCopyright;
import adams.gui.print.ScalableComponentWriter;
import java.awt.Graphics;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

@MixedCopyright
public class SVGWriter
extends ScalableComponentWriter {
    private static final long serialVersionUID = 6049112417449275816L;
    public static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";

    public String globalInfo() {
        return "Outputs scalable vector graphics (SVG).";
    }

    public String getDescription() {
        return "SVG graphic";
    }

    public String[] getExtensions() {
        return new String[]{".svg"};
    }

    public void generateOutput() throws Exception {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(SVG_NAMESPACE, "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        svgGenerator.scale(this.getXScale(), this.getYScale());
        this.m_Component.paintAll((Graphics)svgGenerator);
        boolean useCSS = true;
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.m_OutputFile.getAbsolutePath()));
        svgGenerator.stream((Writer)writer, useCSS);
    }
}

