/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.sink.Null;
import adams.flow.standalone.AbstractStandalone;
import java.util.Date;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class Cron
extends AbstractStandalone
implements ActorHandler {
    private static final long serialVersionUID = 4670761846363281951L;
    public static final String KEY_OWNER = "owner";
    protected AbstractActor m_CronActor;
    protected String m_Schedule;
    protected Scheduler m_Scheduler;

    public String globalInfo() {
        return "Executes an actor according to a pre-defined schedule.\nNote: since the actor merely starts the cron scheduler in the background, the actor finishes the execution pretty much immediately. Therefore, the flow needs to be kept alive in order to let the background jobs getting executed. This can be done with a simple WhileLoop actor using 'true' as expression and a nested Sleep actor.\n\nFor more information on the schedulr format see:\nhttp://www.quartz-scheduler.org/docs/tutorials/crontrigger.html";
    }

    public void defineOptions() {
        super.defineOptions();
        Sequence seq = new Sequence();
        seq.setActors(new AbstractActor[]{new Null()});
        this.m_OptionManager.add("cron-actor", "cronActor", (Object)seq);
        this.m_OptionManager.add("schedule", "schedule", (Object)"0 0 1 * * ?");
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("schedule");
        String result = variable != null ? variable : this.m_Schedule;
        return result;
    }

    protected String checkCronActor(AbstractActor actor) {
        return null;
    }

    protected void updateParent() {
        this.m_CronActor.setParent(null);
        this.m_CronActor.setParent((AbstractActor)this);
    }

    public void setCronActor(AbstractActor value) {
        String msg = this.checkCronActor(value);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_CronActor = value;
        this.reset();
        this.updateParent();
    }

    public AbstractActor getCronActor() {
        return this.m_CronActor;
    }

    public String cronActorTipText() {
        return "The actor to execute according to the cron schedule.";
    }

    public void setSchedule(String value) {
        this.m_Schedule = value;
        this.reset();
    }

    public String getSchedule() {
        return this.m_Schedule;
    }

    public String scheduleTipText() {
        return "The schedule for execution the cron actor; format 'SECOND MINUTE HOUR DAYOFMONTH MONTH WEEKDAY [YEAR]'.";
    }

    public int size() {
        return 1;
    }

    public AbstractActor get(int index) {
        if (index == 0) {
            return this.m_CronActor;
        }
        throw new IndexOutOfBoundsException("Only one item available, requested index: " + index);
    }

    public void set(int index, AbstractActor actor) {
        if (index == 0) {
            this.setCronActor(actor);
        } else {
            this.getSystemErr().println("Index out of range: " + index);
        }
    }

    public int indexOf(String actor) {
        if (this.m_CronActor.getName().equals(actor)) {
            return 0;
        }
        return -1;
    }

    public ActorHandlerInfo getActorHandlerInfo() {
        return new ActorHandlerInfo(false, ActorExecution.SEQUENTIAL, false);
    }

    public int active() {
        if (this.m_CronActor.getSkip()) {
            return 0;
        }
        return 1;
    }

    public AbstractActor firstActive() {
        if (this.m_CronActor.getSkip()) {
            return null;
        }
        return this.m_CronActor;
    }

    public AbstractActor lastActive() {
        if (this.m_CronActor.getSkip()) {
            return null;
        }
        return this.m_CronActor;
    }

    public String check() {
        return null;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.m_CronActor.setUp();
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_Scheduler = new StdSchedulerFactory().getScheduler();
            JobDetail job = new JobDetail(this.getFullName() + ".job", this.getFullName() + ".group", CronJob.class);
            job.getJobDataMap().put((Object)KEY_OWNER, (Object)this);
            CronTrigger trigger = new CronTrigger(this.getFullName() + ".trigger", this.getFullName() + ".group", this.getFullName() + ".job", this.getFullName() + ".group", this.m_Schedule);
            this.m_Scheduler.addJob(job, true);
            Date first = this.m_Scheduler.scheduleJob((Trigger)trigger);
            if (this.isDebugOn()) {
                this.debug("First execution of actor: " + first);
            }
            this.m_Scheduler.start();
        }
        catch (Exception e) {
            String msg = "Failed to set up cron job: ";
            this.getSystemErr().println(msg);
            this.getSystemErr().printStackTrace((Throwable)e);
            result = msg + e;
        }
        return result;
    }

    protected void stopScheduler() {
        if (this.m_Scheduler != null) {
            try {
                this.m_Scheduler.shutdown(true);
            }
            catch (Exception e) {
                this.getSystemErr().println("Error shutting down scheduler:");
                this.getSystemErr().printStackTrace((Throwable)e);
            }
        }
    }

    public void stopExecution() {
        this.m_CronActor.stopExecution();
        this.stopScheduler();
        super.stopExecution();
    }

    public void wrapUp() {
        if (this.m_CronActor != null) {
            this.m_CronActor.wrapUp();
        }
        this.stopScheduler();
        super.wrapUp();
    }

    public void cleanUp() {
        if (this.m_CronActor != null) {
            this.m_CronActor.cleanUp();
        }
        super.cleanUp();
    }

    public static class CronJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            Cron owner = (Cron)((Object)context.getJobDetail().getJobDataMap().get((Object)Cron.KEY_OWNER));
            String result = owner.getCronActor().execute();
            if (result != null) {
                owner.handleError("execute/cron", owner.getFullName() + ": " + result);
                throw new JobExecutionException(owner.getFullName() + ": " + result);
            }
        }
    }
}

