/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MOAHelper;
import adams.data.statistics.StatUtils;
import adams.flow.container.WekaPredictionContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractProcessWekaInstanceWithModel;
import moa.classifiers.Classifier;
import weka.core.Instance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MOAClassifying
extends AbstractProcessWekaInstanceWithModel<Classifier> {
    private static final long serialVersionUID = 5781363684886301467L;
    protected boolean m_OutputInstance;
    protected boolean m_UpdateModel;

    public String globalInfo() {
        return "Uses a serialized MOA model to perform predictions on the data being passed through.\nThe model can also be obtained from a global actor, if the model file is pointing to a directory.\nOptionally, the model can be updated with data being passed through.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-instance", "outputInstance", (Object)false);
        this.m_OptionManager.add("update-model", "updateModel", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_Model = null;
    }

    public void setOutputInstance(boolean value) {
        this.m_OutputInstance = value;
        this.reset();
    }

    public boolean getOutputInstance() {
        return this.m_OutputInstance;
    }

    public String outputInstanceTipText() {
        return "Whether to output weka.core.Instance objects or PredictionContainer objects.";
    }

    public void setUpdateModel(boolean value) {
        this.m_UpdateModel = value;
        this.reset();
    }

    public boolean getUpdateModel() {
        return this.m_UpdateModel;
    }

    public String updateModelTipText() {
        return "Whether to update the model with the Instance (in case its class value isn't missing) after making the prediction.";
    }

    public Class[] generates() {
        return new Class[]{WekaPredictionContainer.class, Instance.class};
    }

    protected Token processInstance(Instance inst) throws Exception {
        Token result;
        double[] votes = MOAHelper.fixVotes(((Classifier)this.m_Model).getVotesForInstance(inst), inst);
        WekaPredictionContainer cont = new WekaPredictionContainer(inst, (double)StatUtils.maxIndex((double[])votes), votes);
        if (this.m_UpdateModel && !inst.classIsMissing()) {
            ((Classifier)this.m_Model).trainOnInstance(inst);
        }
        if (this.m_OutputInstance) {
            inst = (Instance)((Instance)cont.getValue("Instance")).copy();
            inst.setClassValue(((Double)cont.getValue("Classification")).doubleValue());
            result = new Token((Object)inst);
        } else {
            result = new Token((Object)((WekaPredictionContainer)cont.getClone()));
        }
        return result;
    }
}

