/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.util.List;
import javax.swing.JPanel;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.model.PrintedPage;
import org.jopendocument.model.draw.DrawFrame;
import org.jopendocument.model.draw.DrawImage;
import org.jopendocument.model.office.OfficeBody;
import org.jopendocument.model.office.OfficeSpreadsheet;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.style.StyleTableCellProperties;
import org.jopendocument.model.table.TableShapes;
import org.jopendocument.model.table.TableTable;
import org.jopendocument.model.table.TableTableCell;
import org.jopendocument.model.table.TableTableColumn;
import org.jopendocument.model.table.TableTableRow;
import org.jopendocument.renderer.ODTCellBackgroundRenderer;
import org.jopendocument.renderer.ODTCellBorderRenderer;
import org.jopendocument.renderer.ODTCellImageRenderer;
import org.jopendocument.renderer.ODTCellRenderer;
import org.jopendocument.renderer.ODTCellTextRenderer;
import org.jopendocument.util.ValueHelper;

public class ODTRenderer
extends JPanel {
    private static final long serialVersionUID = -4903349568929293597L;
    private double resizeFactor;
    private OfficeBody body;
    private TableTable table;
    private int printHeightPixel;
    private int printWidthPixel;
    private int printWidth;
    private int printHeight;
    private static final ODTCellBackgroundRenderer backgroundRenderer = new ODTCellBackgroundRenderer();
    private static final ODTCellBorderRenderer borderRenderer = new ODTCellBorderRenderer();
    private static final ODTCellTextRenderer textRenderer = new ODTCellTextRenderer();
    private static final ODTCellImageRenderer imageRenderer = new ODTCellImageRenderer();
    private static boolean debug = false;
    private PrintedPage currentPage;
    private boolean paintMaxResolution;
    private boolean ignoreMargins;
    private OpenDocument od;
    private int currentPageIndex;

    public ODTRenderer(OpenDocument openDocument) {
        this.body = openDocument.getBody();
        this.setBackground(Color.WHITE);
        this.currentPageIndex = 0;
        this.currentPage = openDocument.getPrintedPage(this.currentPageIndex);
        this.setResizeFactor(360.0);
        this.od = openDocument;
    }

    public void setCurrentPage(int n) {
        this.currentPageIndex = n;
        this.currentPage = this.od.getPrintedPage(n);
        this.updateSize();
        this.repaint();
    }

    private void updateSize() {
        this.setSize(this.getPageWidthInPixel(), this.getPageHeightInPixel());
    }

    public double getPageHeight() {
        return (double)this.getPageHeightInPixel() * this.resizeFactor;
    }

    public int getPageHeightInPixel() {
        int n = 0;
        for (TableTableRow tableTableRow : this.currentPage.getRows()) {
            n += (int)((double)tableTableRow.getHeight() / this.resizeFactor);
        }
        return n;
    }

    public double getPageWidth() {
        return (double)this.getPageWidthInPixel() * this.resizeFactor;
    }

    public int getPageWidthInPixel() {
        int n = this.table.getPrintStartCol();
        int n2 = this.table.getPrintStopCol();
        TableTableRow[] tableTableRowArray = this.currentPage.getRows();
        double d = this.resizeFactor;
        int n3 = this.table.getPageLayoutProperties().getMarginLeft();
        if (this.ignoreMargins) {
            n3 = 0;
        }
        int n4 = (int)((double)n3 / d);
        TableTableColumn[] tableTableColumnArray = this.table.getColumns().toArray(new TableTableColumn[0]);
        for (int i = 0; i < 1; ++i) {
            TableTableRow tableTableRow = tableTableRowArray[i];
            TableTableCell[] tableTableCellArray = tableTableRow.getCellsInRange(n, n2);
            int n5 = tableTableCellArray.length;
            for (int j = 0; j < n5; ++j) {
                TableTableCell tableTableCell = tableTableCellArray[j];
                if (tableTableCell == null) continue;
                TableTableColumn tableTableColumn = tableTableColumnArray[n + j];
                StyleStyle styleStyle = tableTableCell.getStyle();
                n4 += (int)((double)tableTableColumn.getWidth() / this.resizeFactor);
            }
        }
        return n4;
    }

    public int getPrintedPagesNumber() {
        return this.od.getPrintedPageCount();
    }

    public synchronized void setResizeFactor(double d) {
        this.resizeFactor = d;
        List<OfficeSpreadsheet> list = this.body.getOfficeSpreadsheets();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            TableTable tableTable;
            int n2 = 0;
            List<TableTable> list2 = list.get(i).getTables();
            if (n2 >= list2.size()) continue;
            this.table = tableTable = list2.get(n2);
            this.printWidth = tableTable.getPrintWidth() + tableTable.getPageLayoutProperties().getMarginLeft() + tableTable.getPageLayoutProperties().getMarginRight();
            this.printHeight = tableTable.getPageLayoutProperties().getPageHeight();
            if (this.ignoreMargins) {
                this.printWidth = tableTable.getPrintWidth();
                this.printHeight = tableTable.getPrintHeight();
            }
            this.printWidthPixel = (int)Math.ceil((double)this.printWidth / d);
            this.printHeightPixel = (int)Math.ceil((double)this.printHeight / d);
            this.setPreferredSize(new Dimension(this.printWidthPixel, this.printHeightPixel));
        }
        this.updateSize();
        this.repaint();
    }

    public int getPrintWidthInPixel() {
        return this.printWidthPixel;
    }

    public int getPrintHeightInPixel() {
        return this.printHeightPixel;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (debug) {
            this.printRendererInformation();
            System.out.println("********************** RENDERING BACKGROUND *************");
        }
        this.drawODTBackground(graphics2D);
        if (debug) {
            System.out.println("********************** RENDERING BORDERS *************");
        }
        this.drawODTBorders(graphics2D);
        if (debug) {
            System.out.println("********************** RENDERING TEXTS *************");
        }
        this.drawODTText(graphics2D);
        if (debug) {
            System.out.println("********************** RENDERING IMAGES *************");
        }
        this.drawODTImages(graphics2D);
    }

    private final void drawODTImages(Graphics2D graphics2D) {
        if (!this.paintMaxResolution) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }
        this.drawCells(graphics2D, imageRenderer);
        TableTable tableTable = this.table;
        TableShapes tableShapes = tableTable.getTableShapes();
        if (tableShapes == null) {
            return;
        }
        List<DrawFrame> list = tableShapes.getDrawFrames();
        double d = this.resizeFactor;
        int n = (int)((double)tableTable.getPageLayoutProperties().getMarginLeft() / d);
        int n2 = (int)((double)tableTable.getPageLayoutProperties().getMarginRight() / d);
        int n3 = (int)((double)tableTable.getPageLayoutProperties().getMarginTop() / d);
        int n4 = (int)((double)tableTable.getPageLayoutProperties().getMarginBottom() / d);
        if (this.ignoreMargins) {
            n = 0;
            n2 = 0;
            n3 = 0;
            n4 = 0;
        }
        for (DrawFrame drawFrame : list) {
            DrawImage drawImage = drawFrame.getDrawImage();
            if (drawImage == null) continue;
            double d2 = (double)n + (double)ValueHelper.getLength(drawFrame.getSvgX()) / this.resizeFactor;
            double d3 = (double)n3 + (double)ValueHelper.getLength(drawFrame.getSvgY()) / this.resizeFactor;
            double d4 = (double)ValueHelper.getLength(drawFrame.getSvgWidth()) / this.resizeFactor;
            double d5 = (double)ValueHelper.getLength(drawFrame.getSvgHeight()) / this.resizeFactor;
            Image image = null;
            if (!this.paintMaxResolution) {
                image = this.body.getDocument().getImage(drawImage.getXlinkHref(), (int)d4, (int)d5);
                graphics2D.drawImage(image, (int)Math.round(d2), (int)Math.round(d3), null);
                continue;
            }
            image = this.body.getDocument().getImage(drawImage.getXlinkHref());
            graphics2D.drawImage(image, (int)Math.round(d2), (int)Math.round(d3), (int)Math.round(d4), (int)Math.round(d5), null);
        }
    }

    private final void drawODTText(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.drawCells(graphics2D, textRenderer);
    }

    private final void drawODTBorders(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.drawCells(graphics2D, borderRenderer);
    }

    private final void drawODTBackground(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.drawCells(graphics2D, backgroundRenderer);
    }

    private final void drawCells(Graphics2D graphics2D, ODTCellRenderer oDTCellRenderer) {
        TableTable tableTable = this.table;
        int n = tableTable.getPrintStartCol();
        int n2 = tableTable.getPrintStopCol();
        TableTableRow[] tableTableRowArray = this.currentPage.getRows();
        int n3 = tableTableRowArray.length;
        double d = this.resizeFactor;
        int n4 = tableTable.getPageLayoutProperties().getMarginLeft();
        int n5 = tableTable.getPageLayoutProperties().getMarginTop();
        if (this.ignoreMargins) {
            n4 = 0;
            n5 = 0;
        }
        int n6 = (int)((double)n4 / d);
        TableTableColumn[] tableTableColumnArray = this.table.getColumns().toArray(new TableTableColumn[0]);
        int n7 = (int)((double)n5 / d);
        for (int i = 0; i < n3; ++i) {
            TableTableRow tableTableRow = tableTableRowArray[i];
            int n8 = (int)((double)tableTableRow.getHeight() / d);
            TableTableCell[] tableTableCellArray = tableTableRow.getCellsInRange(n, n2);
            int n9 = tableTableCellArray.length;
            int n10 = n6;
            for (int j = 0; j < n9; ++j) {
                int n11;
                TableTableCell tableTableCell = tableTableCellArray[j];
                if (tableTableCell == null) continue;
                TableTableColumn tableTableColumn = tableTableColumnArray[n + j];
                StyleStyle styleStyle = tableTableCell.getStyle();
                int n12 = (int)((double)tableTableColumn.getWidth() / d);
                StyleTableCellProperties styleTableCellProperties = styleStyle.getStyleTableCellProperties();
                int n13 = n8;
                if (tableTableCell.getTableNumberRowsSpanned() > 1) {
                    for (n11 = 1; n11 < tableTableCell.getTableNumberRowsSpanned(); ++n11) {
                        n13 = (int)((double)n13 + (double)tableTableRowArray[i + n11].getHeight() / d);
                    }
                }
                if (tableTableCell.getTableNumberColumnsSpanned() > 1) {
                    for (n11 = 1; n11 < tableTableCell.getTableNumberColumnsSpanned(); ++n11) {
                        int n14 = n + j + n11;
                        double d2 = (double)tableTableColumnArray[n14].getWidth() / d;
                        n12 = (int)((double)n12 + d2);
                    }
                }
                try {
                    oDTCellRenderer.draw(graphics2D, n10, n7, n12, n13, d, tableTableCell, styleTableCellProperties);
                }
                catch (Exception exception) {
                    System.err.println("Failed on x:" + n10 + " y:" + n7 + " Cell:" + tableTableCell);
                    exception.printStackTrace();
                }
                n10 += n12;
            }
            n7 += n8;
        }
    }

    public double getPrintWidth() {
        return this.printWidth;
    }

    public double getPrintHeight() {
        return this.printHeight;
    }

    public void setPaintMaxResolution(boolean bl) {
        this.paintMaxResolution = bl;
        imageRenderer.setPaintMaxResolution(bl);
    }

    public void setIgnoreMargins(boolean bl) {
        this.ignoreMargins = bl;
    }

    public void printRendererInformation() {
        System.out.println("==== Spreadsheet Renderer ===");
        System.out.println("Rendering file: " + this.od.getZipFile().getName());
        System.out.println("Document margins ignored: " + this.ignoreMargins);
        System.out.println("Max image quality: " + this.paintMaxResolution);
        System.out.println("Current page: " + (this.currentPageIndex + 1) + "  / " + this.getPrintedPagesNumber());
        System.out.println("Width: " + (long)this.getPrintWidth() + " micrometers (" + this.getPrintWidth() / 10000.0 + " cms)");
        System.out.println("Height: " + (long)this.getPrintHeight() + " micrometers (" + this.getPrintHeight() / 10000.0 + " cms)");
        System.out.println("Size in pixels: " + this.getPrintWidthInPixel() + "x" + this.getPrintHeightInPixel());
        System.out.println("Resize factor " + this.resizeFactor);
        System.out.println("Page:" + this.currentPage.getRows().length + " rows ");
        System.out.println();
    }

    public void setDebug(boolean bl) {
        debug = true;
    }
}

