/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeTools;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeByteType;
import de.intarsys.nativec.type.NativeNumber;
import de.intarsys.nativec.type.NativeType;

public class NativeByte
extends NativeNumber {
    public static final NativeByteType META = new NativeByteType();

    static {
        NativeType.register(NativeByte.class, META);
    }

    public static NativeByte createFromAddress(long address) {
        return (NativeByte)META.createNative(NativeTools.toHandle(address));
    }

    public NativeByte() {
        this.allocate();
    }

    public NativeByte(byte value) {
        this.allocate();
        this.setValue(value);
    }

    protected NativeByte(INativeHandle handle) {
        super(handle);
    }

    public byte byteValue() {
        return this.handle.getByte(0);
    }

    public INativeType getNativeType() {
        return META;
    }

    public Object getValue() {
        return new Byte(this.byteValue());
    }

    public int intValue() {
        return this.byteValue();
    }

    public long longValue() {
        return this.byteValue();
    }

    public void setValue(byte value) {
        this.handle.setByte(0, value);
    }

    public void setValue(Object value) {
        this.setValue(((Number)value).byteValue());
    }

    public short shortValue() {
        return this.byteValue();
    }

    public String toString() {
        if (this.getNativeHandle().getAddress() == 0L) {
            return "nope - null pointer";
        }
        return String.valueOf(this.byteValue());
    }
}

