/*
 * Decompiled with CFR 0.152.
 */
package adams.data.report;

import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.RegularField;

public class Field
extends AbstractField
implements RegularField {
    private static final long serialVersionUID = -5720659277852926115L;

    public Field() {
    }

    public Field(AbstractField field) {
        super(field);
    }

    public Field(String name, DataType dt) {
        super(name, dt);
    }

    @Override
    protected AbstractField newField(String name, DataType dtype) {
        return new Field(name, dtype);
    }

    @Override
    public AbstractField replacePrefix(String prefix) {
        if (!this.isCompound()) {
            return this.getClone();
        }
        return new Field(prefix + "\t" + this.getSuffix(), this.getDataType());
    }

    @Override
    public AbstractField replaceSuffix(String suffix) {
        if (!this.isCompound()) {
            return this.getClone();
        }
        return new Field(this.getPrefix() + "\t" + suffix, this.getDataType());
    }

    public static AbstractField parseField(String s) {
        String typeStr;
        String name = s;
        DataType type = DataType.UNKNOWN;
        if (s.length() > 3 && s.endsWith("]") && (typeStr = s.substring(s.length() - 3)).startsWith("[") && typeStr.length() == 3) {
            typeStr = typeStr.substring(1, 2);
            for (DataType t : DataType.values()) {
                if (!t.toDisplay().equals(typeStr)) continue;
                type = t;
                name = s.substring(0, s.length() - 3);
                break;
            }
        }
        Field result = new Field(Field.unescape(name), type);
        return result;
    }

    public static void main(String[] args) {
        String s = "hello_world";
        AbstractField f = Field.parseField(s);
        System.out.println(s + " -> " + f.getName() + "/" + f.getDataType());
        System.out.println("  -> toString: " + f);
        System.out.println("  -> toParseableString: " + f.toParseableString());
        s = "hello[S]";
        f = Field.parseField(s);
        System.out.println(s + " -> " + f.getName() + "/" + f.getDataType());
        System.out.println("  -> toString: " + f);
        System.out.println("  -> toParseableString: " + f.toParseableString());
        s = "hello[s]world[B]";
        f = Field.parseField(s);
        System.out.println(s + " -> " + f.getName() + "/" + f.getDataType());
        System.out.println("  -> toString: " + f);
        System.out.println("  -> toParseableString: " + f.toParseableString());
    }
}

