/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractGlobalActor;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.Hashtable;

public class GlobalSink
extends AbstractGlobalActor
implements InputConsumer {
    private static final long serialVersionUID = 4736661460553985100L;
    public static final String BACKUP_CURRENT = "current";
    protected transient Token m_CurrentInput;

    @Override
    public String globalInfo() {
        return "Lets a global sink consume the input tokens.";
    }

    @Override
    protected AbstractActor findGlobalActor() {
        AbstractActor result = super.findGlobalActor();
        if (result != null && !(result instanceof InputConsumer)) {
            this.getSystemErr().println("Global actor '" + result.getFullName() + "' does not consume any input!");
            result = null;
        }
        return result;
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_CURRENT, this.m_CurrentInput);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CURRENT)) {
            this.m_CurrentInput = (Token)state.get(BACKUP_CURRENT);
            state.remove(BACKUP_CURRENT);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_CurrentInput = null;
    }

    @Override
    public Class[] accepts() {
        if (this.m_GlobalActor != null) {
            return ((InputConsumer)((Object)this.m_GlobalActor)).accepts();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    public void input(Token token) {
        this.m_CurrentInput = token;
    }

    @Override
    protected String executeGlobalActor() {
        ((InputConsumer)((Object)this.m_GlobalActor)).input(this.m_CurrentInput);
        String result = this.m_GlobalActor.execute();
        return result;
    }
}

