/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.action;

import adams.gui.core.GUIHelper;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public abstract class AbstractBaseAction
extends AbstractAction {
    private static final long serialVersionUID = -7695092075151409689L;

    public AbstractBaseAction() {
        this.initialize();
    }

    public AbstractBaseAction(String name) {
        this();
        this.setName(name);
    }

    public AbstractBaseAction(String name, Icon icon) {
        this(name);
        this.setIcon(icon);
    }

    public AbstractBaseAction(String name, String icon) {
        this(name, GUIHelper.getIcon(icon));
    }

    protected void initialize() {
        this.putValue("SwingSelectedKey", false);
    }

    public void setName(String value) {
        this.putValue("Name", value);
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public void setIcon(Icon value) {
        this.putValue("SmallIcon", value);
        this.putValue("SwingLargeIconKey", value);
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    public void setSelected(boolean value) {
        this.putValue("SwingSelectedKey", value);
    }

    public boolean isSelected() {
        return (Boolean)this.getValue("SwingSelectedKey");
    }

    public void setMnemonic(int value) {
        this.putValue("MnemonicKey", value);
    }

    public boolean hasMnemonic() {
        return this.getValue("MnemonicKey") != null;
    }

    public KeyStroke getMnemonic() {
        if (this.hasMnemonic()) {
            return (KeyStroke)this.getValue("MnemonicKey");
        }
        return null;
    }

    public void setAccelerator(String value) {
        this.putValue("AcceleratorKey", GUIHelper.getKeyStroke(value));
    }

    public boolean hasAccelerator() {
        return this.getValue("AcceleratorKey") != null;
    }

    public KeyStroke getAccelerator() {
        if (this.hasAccelerator()) {
            return (KeyStroke)this.getValue("AcceleratorKey");
        }
        return null;
    }

    public void setToolTipText(String value) {
        this.putValue("ShortDescription", value);
    }

    public boolean hasToolTipText() {
        return this.getValue("ShortDescription") != null;
    }

    public String getToolTipText() {
        if (this.hasToolTipText()) {
            return (String)this.getValue("ShortDescription");
        }
        return null;
    }
}

