/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.data.instance.Instance;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.AbstractTextDisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.TextSupplier;
import adams.gui.core.BasePanel;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceContainerManager;
import adams.gui.visualization.instance.InstancePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import weka.core.Instances;

public class WekaInstanceViewer
extends AbstractGraphicalDisplay
implements DisplayPanelProvider,
TextSupplier {
    private static final long serialVersionUID = 1283926389472133810L;
    protected InstancePanel m_InstancePanel;

    public String globalInfo() {
        return "Actor for displaying adams.data.instance.Instance objects in a graphical way (using the internal format), like the 'Instance Explorer' tool.";
    }

    protected int getDefaultWidth() {
        return 800;
    }

    protected int getDefaultHeight() {
        return 500;
    }

    public void clearPanel() {
        ((InstanceContainerManager)this.m_InstancePanel.getContainerManager()).clear();
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_InstancePanel = new InstancePanel();
        result.add((Component)((Object)this.m_InstancePanel), (Object)"Center");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{weka.core.Instance.class, Instance.class};
    }

    protected void display(Token token) {
        Instance inst;
        if (token.getPayload() instanceof weka.core.Instance) {
            inst = new Instance();
            inst.set((weka.core.Instance)token.getPayload());
        } else {
            inst = (Instance)((Object)token.getPayload());
        }
        InstanceContainerManager manager = (InstanceContainerManager)this.m_InstancePanel.getContainerManager();
        InstanceContainer cont = manager.newContainer((Comparable)((Object)inst));
        manager.add(cont);
    }

    protected void cleanUpGUI() {
        super.cleanUpGUI();
        if (this.m_InstancePanel != null) {
            ((InstanceContainerManager)this.m_InstancePanel.getContainerManager()).clear();
        }
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        AbstractTextDisplayPanel result = new AbstractTextDisplayPanel("Instance Viewer"){
            private static final long serialVersionUID = -5618543590920864397L;
            protected InstancePanel m_InstancePanel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_InstancePanel = new InstancePanel();
                this.add((Component)((Object)this.m_InstancePanel), "Center");
            }

            public void display(Token token) {
                Instance inst = null;
                if (token.getPayload() instanceof weka.core.Instance) {
                    inst = new Instance();
                    inst.set((weka.core.Instance)token.getPayload());
                } else {
                    inst = (Instance)((Object)token.getPayload());
                }
                InstanceContainerManager manager = (InstanceContainerManager)this.m_InstancePanel.getContainerManager();
                InstanceContainer cont = manager.newContainer((Comparable)((Object)inst));
                manager.add(cont);
            }

            public String supplyText() {
                return WekaInstanceViewer.supplyText(this.m_InstancePanel);
            }

            public void cleanUp() {
                ((InstanceContainerManager)this.m_InstancePanel.getContainerManager()).clear();
            }
        };
        result.display(token);
        return result;
    }

    public String supplyText() {
        return WekaInstanceViewer.supplyText(this.m_InstancePanel);
    }

    protected static String supplyText(InstancePanel panel) {
        InstanceContainerManager manager = (InstanceContainerManager)panel.getContainerManager();
        if (manager.countVisible() == 0) {
            return null;
        }
        Instances data = new Instances(manager.getVisible(0).getData().getDatasetHeader());
        for (int i = 0; i < manager.countVisible(); ++i) {
            data.add(manager.getVisible(i).getData().toInstance());
        }
        return data.toString();
    }

    public boolean displayPanelRequiresScrollPane() {
        return true;
    }
}

