/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.zscore;

import adams.core.Index;
import adams.core.base.BaseRegExp;
import adams.data.instance.Instance;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.ParameterPanel;
import adams.gui.event.PaintListener;
import adams.gui.goe.GenericArrayEditorPanel;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.core.plot.TipTextCustomizer;
import adams.gui.visualization.instance.InstanceContainer;
import adams.gui.visualization.instance.InstanceExplorer;
import adams.gui.visualization.stats.core.IndexSet;
import adams.gui.visualization.stats.paintlet.AbstractZScorePaintlet;
import adams.gui.visualization.stats.paintlet.ZScoreCircle;
import adams.gui.visualization.stats.zscore.AbstractZScoreOverlay;
import adams.gui.visualization.stats.zscore.DisplayExplorer;
import adams.gui.visualization.stats.zscore.ZScoreHitDetector;
import adams.gui.visualization.stats.zscore.ZScorePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.core.Attribute;
import weka.core.Instances;

public class ZScore
extends PaintablePanel
implements TipTextCustomizer,
PopupMenuCustomizer {
    private static final long serialVersionUID = 1398942330181177958L;
    protected ZScorePanel m_Plot;
    protected Instances m_Instances;
    protected AbstractZScorePaintlet m_Val;
    protected AbstractZScorePaintlet m_Def;
    protected AbstractZScoreOverlay[] m_Over;
    protected AbstractZScoreOverlay[] m_Default;
    protected int m_Index;
    protected DefaultComboBoxModel m_ComboBox;
    protected JComboBox m_Att;
    protected GenericObjectEditorPanel m_PanelPaintlet;
    protected GenericArrayEditorPanel m_PanelOverlay;
    protected JPanel m_Key;
    protected BaseRegExp m_AttReg;
    protected Index m_Indx;
    protected ZScoreHitDetector m_Detect;
    protected ArrayList<DisplayExplorer> dialogs;
    protected int m_NumDialogs;
    protected BaseSplitPane m_SplitPane;

    protected void initialize() {
        super.initialize();
        this.m_Index = 0;
        this.m_NumDialogs = 0;
        this.m_AttReg = new BaseRegExp();
        this.m_Indx = new Index();
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public PlotPanel getPlot() {
        return this.m_Plot;
    }

    public void prepareUpdate() {
        if (this.m_Instances != null) {
            for (int i = 0; i < this.m_Over.length; ++i) {
                if (this.m_Over[i].getPaintlet() == null) continue;
                this.m_Over[i].getPaintlet().parameters(this.m_Instances, this.m_Index);
                if (this.m_Over[i].getPaintlet().getCalculated()) continue;
                this.m_Over[i].getPaintlet().calculate();
            }
        }
    }

    protected boolean canPaint(Graphics g) {
        return this.m_Plot != null;
    }

    public void reset() {
        for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
            this.m_ComboBox.addElement(this.m_Instances.attribute(i).name());
        }
        int temp = -1;
        if ((temp = IndexSet.getIndex(this.m_AttReg, this.m_Indx, this.m_Instances, temp)) == -1) {
            temp = 0;
            System.err.println("changed to 0");
        }
        if (this.m_Over == null) {
            this.m_Over = new AbstractZScoreOverlay[0];
        }
        this.m_Att.setSelectedIndex(this.m_Index);
        this.m_Val.setPanel(this);
        this.m_Val.setInstances(this.m_Instances);
        this.change();
    }

    private void changeOverlay() {
        int i;
        this.removeOverlays();
        int len = ((AbstractZScoreOverlay[])this.m_PanelOverlay.getCurrent()).length;
        this.m_Over = new AbstractZScoreOverlay[len];
        for (i = 0; i < len; ++i) {
            this.m_Over[i] = ((AbstractZScoreOverlay[])this.m_PanelOverlay.getCurrent())[i].shallowCopy(true);
        }
        for (i = 0; i < this.m_Over.length; ++i) {
            AbstractZScoreOverlay temp = this.m_Over[i];
            temp.setInstances(this.m_Instances);
            temp.setParent(this);
            temp.setUp();
        }
        this.changeKey();
        this.repaint();
    }

    public void removeOverlays() {
        if (this.m_Over != null) {
            for (int i = 0; i < this.m_Over.length; ++i) {
                if (this.m_Over[i].getPaintlet() == null) continue;
                this.removePaintlet(this.m_Over[i].getPaintlet());
            }
            this.m_Over = null;
        }
    }

    protected void changePaintlet() {
        this.removePaintlet(this.m_Val);
        this.m_Val = (AbstractZScorePaintlet)((Object)this.m_PanelPaintlet.getCurrent());
        this.m_Val.setPanel(this);
        this.m_Val.setIndex(this.m_Index);
        this.m_Val.setInstances(this.m_Instances);
        this.change();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Plot = new ZScorePanel();
        this.m_Plot.addPaintListener((PaintListener)this);
        ParameterPanel optionPanel = new ParameterPanel();
        this.m_SplitPane = new BaseSplitPane(1);
        this.m_SplitPane.setLeftComponent((Component)((Object)this.m_Plot));
        JPanel hold = new JPanel(new BorderLayout());
        hold.add((Component)optionPanel, "North");
        this.m_SplitPane.setRightComponent((Component)hold);
        this.m_SplitPane.setResizeWeight(1.0);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.add((Component)this.m_SplitPane, "Center");
        hold.setPreferredSize(new Dimension(500, 0));
        this.m_ComboBox = new DefaultComboBoxModel();
        this.m_Att = new JComboBox(this.m_ComboBox);
        AttListener listen = new AttListener(this);
        this.m_Att.addItemListener(listen);
        if (this.m_Val == null) {
            this.m_Def = new ZScoreCircle();
            this.m_Val = new ZScoreCircle();
        } else {
            this.m_Def = this.m_Val;
        }
        this.m_PanelPaintlet = new GenericObjectEditorPanel(AbstractZScorePaintlet.class, (Object)this.m_Def, true);
        this.m_PanelPaintlet.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ZScore.this.changePaintlet();
            }
        });
        this.m_Default = new AbstractZScoreOverlay[0];
        this.m_PanelOverlay = new GenericArrayEditorPanel((Object)this.m_Default);
        this.changeOverlay();
        this.m_PanelOverlay.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ZScore.this.changeOverlay();
            }
        });
        JPanel east = new JPanel(new BorderLayout());
        east.setPreferredSize(new Dimension(100, 50));
        JLabel title = new JLabel("key");
        title.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        JPanel titleHolder = new JPanel();
        titleHolder.add(title);
        this.m_Key = new JPanel();
        this.m_Key.setBackground(Color.WHITE);
        this.m_Key.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.m_Key.setLayout(new BoxLayout(this.m_Key, 1));
        JPanel keyHold = new JPanel();
        this.m_Key.setPreferredSize(new Dimension(100, 200));
        keyHold.add(this.m_Key);
        JPanel south = new JPanel(new BorderLayout());
        south.add((Component)titleHolder, "North");
        south.add((Component)keyHold, "South");
        east.add((Component)south, "South");
        JCheckBox grid = new JCheckBox();
        grid.addItemListener(new gridListener());
        this.changeKey();
        optionPanel.addParameter("attribute", (Component)this.m_Att);
        optionPanel.addParameter("Paintlet", (Component)this.m_PanelPaintlet);
        optionPanel.addParameter("Overlays", (Component)this.m_PanelOverlay);
        optionPanel.addParameter("Add grid", (Component)grid);
        hold.add((Component)east, "Center");
        this.m_Detect = new ZScoreHitDetector(this);
        this.getPlot().setTipTextCustomizer((TipTextCustomizer)this);
        this.getPlot().setPopupMenuCustomizer((PopupMenuCustomizer)this);
    }

    private void changeKey() {
        if (this.m_Key != null) {
            this.m_Key.removeAll();
            int len = this.m_Over.length;
            for (int i = 0; i < len; ++i) {
                JButton temp = new JButton(this.m_Over[i].shortName());
                temp.setBorder(null);
                temp.setFocusPainted(false);
                temp.setMargin(new Insets(0, 0, 0, 0));
                temp.setContentAreaFilled(false);
                temp.setBorderPainted(false);
                temp.setOpaque(false);
                temp.setForeground(this.m_Over[i].getColor());
                this.m_Key.add(temp);
                temp.addActionListener(new pushButton());
            }
            this.repaint();
            this.revalidate();
        }
    }

    public void change() {
        if (this.m_Instances != null) {
            this.m_Plot.setInstances(this.m_Instances);
            this.m_Plot.setIndex(this.m_Index);
            this.m_Plot.reset();
            this.m_Val.setIndex(this.m_Index);
            this.m_Val.setInstances(this.m_Instances);
            this.update();
            this.validate();
            this.repaint();
        }
    }

    public int getIndex() {
        return this.m_Index;
    }

    public void setOverlays(AbstractZScoreOverlay[] val) {
        this.m_PanelOverlay.setCurrent((Object)val);
        this.changeOverlay();
    }

    public void setPaintlet(AbstractZScorePaintlet val) {
        this.m_PanelPaintlet.setCurrent((Object)val);
        this.removePaintlet(this.m_Val);
        this.m_Val = val;
    }

    public void setAttReg(BaseRegExp val) {
        this.m_AttReg = val;
    }

    public void setAttindex(Index val) {
        this.m_Indx = val;
    }

    public String processTipText(PlotPanel panel, Point mouse, String tiptext) {
        String result = "";
        MouseEvent event = new MouseEvent((Component)this.getPlot().getContent(), 503, new Date().getTime(), 0, (int)mouse.getX(), (int)mouse.getY(), 0, false);
        String hit = (String)this.m_Detect.detect(event);
        if (hit != null) {
            result = result + hit;
        }
        return result;
    }

    public void customizePopupMenu(MouseEvent e, JPopupMenu menu) {
        if (this.dialogs == null) {
            this.dialogs = new ArrayList();
        }
        if (this.m_Detect.detect(e) != null) {
            String info = (String)this.m_Detect.detect(e);
            String text = info.substring(info.indexOf(":") + 1, info.indexOf(","));
            int pos = Integer.parseInt(text);
            final Instance inst = new Instance();
            inst.setID(pos + 1 + ". " + this.m_Instances.relationName());
            inst.set(this.m_Instances.instance(pos));
            if (this.dialogs.size() == 0) {
                JMenuItem view = new JMenuItem();
                view.setText("View instance...");
                view.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        ++ZScore.this.m_NumDialogs;
                        final DisplayExplorer temp = new DisplayExplorer();
                        temp.setName("Explorer (" + ZScore.this.m_NumDialogs + ")");
                        temp.setTitle("Explorer (" + ZScore.this.m_NumDialogs + ")");
                        InstanceExplorer explore = new InstanceExplorer();
                        temp.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent we) {
                                ZScore.this.dialogs.remove((Object)temp);
                                temp.dispose();
                            }
                        });
                        temp.setDefaultCloseOperation(0);
                        explore = new InstanceExplorer();
                        Vector<InstanceContainer> data = new Vector<InstanceContainer>();
                        data.add(explore.getContainerManager().newContainer((Comparable)inst));
                        explore.getContainerManager().addAll(data);
                        temp.add((Component)explore);
                        temp.setPreferredSize(new Dimension(900, 500));
                        temp.pack();
                        temp.setVisible(true);
                        ZScore.this.dialogs.add(temp);
                        temp.setExplore(explore);
                    }
                });
                menu.addSeparator();
                menu.add(view);
            } else {
                menu.addSeparator();
                if (this.dialogs.size() > 1) {
                    JMenu samePanel = new JMenu();
                    samePanel.setToolTipText("Display this instance on an existing instance explorer");
                    samePanel.setText("Display on existing panel");
                    menu.add(samePanel);
                    int i = 0;
                    while (i < this.dialogs.size()) {
                        JMenuItem sub = new JMenuItem();
                        sub.setText(this.dialogs.get(i).getName());
                        final int y = i++;
                        sub.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DisplayExplorer temp = ZScore.this.dialogs.get(y);
                                InstanceExplorer explore = temp.getExplore();
                                Vector<InstanceContainer> data = new Vector<InstanceContainer>();
                                data.add(explore.getContainerManager().newContainer((Comparable)inst));
                                explore.getContainerManager().addAll(data);
                                temp.repaint();
                            }
                        });
                        samePanel.add(sub);
                    }
                } else {
                    JMenuItem samePanel = new JMenuItem();
                    samePanel.setToolTipText("Display this instance on the existing instance explorer");
                    samePanel.setText("Display on existing panel");
                    menu.add(samePanel);
                    samePanel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            DisplayExplorer temp = ZScore.this.dialogs.get(0);
                            InstanceExplorer explore = temp.getExplore();
                            Vector<InstanceContainer> data = new Vector<InstanceContainer>();
                            data.add(explore.getContainerManager().newContainer((Comparable)inst));
                            explore.getContainerManager().addAll(data);
                            temp.repaint();
                        }
                    });
                }
                JMenuItem diffPanel = new JMenuItem();
                diffPanel.setText("Display on a new panel");
                menu.add(diffPanel);
                diffPanel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        ++ZScore.this.m_NumDialogs;
                        final DisplayExplorer temp = new DisplayExplorer();
                        temp.setName("Explorer (" + ZScore.this.m_NumDialogs + ")");
                        temp.setTitle("Explorer (" + ZScore.this.m_NumDialogs + ")");
                        InstanceExplorer explore = new InstanceExplorer();
                        temp.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent we) {
                                ZScore.this.dialogs.remove((Object)temp);
                                temp.dispose();
                            }
                        });
                        temp.setDefaultCloseOperation(0);
                        explore = new InstanceExplorer();
                        Vector<InstanceContainer> data = new Vector<InstanceContainer>();
                        data.add(explore.getContainerManager().newContainer((Comparable)inst));
                        explore.getContainerManager().addAll(data);
                        temp.add((Component)explore);
                        temp.setPreferredSize(new Dimension(900, 500));
                        temp.pack();
                        temp.setVisible(true);
                        ZScore.this.dialogs.add(temp);
                        temp.setExplore(explore);
                    }
                });
            }
        }
    }

    public void setOptionsVisible(boolean value) {
        this.m_SplitPane.setRightComponentHidden(!value);
    }

    public boolean getOptionsVisible() {
        return !this.m_SplitPane.isRightComponentHidden();
    }

    protected class AttListener
    implements ItemListener {
        ZScore m_parent;

        public AttListener(ZScore parent) {
            this.m_parent = parent;
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            Instances inst = this.m_parent.getInstances();
            if (arg0.getStateChange() == 1) {
                String item = (String)arg0.getItem();
                Attribute chose = inst.attribute(item);
                for (int i = 0; i < inst.numAttributes(); ++i) {
                    if (inst.attribute(i) != chose) continue;
                    ZScore.this.m_Index = i;
                    for (int t = 0; t < ZScore.this.m_Over.length; ++t) {
                        ZScore.this.m_Over[t].getPaintlet().setCalculated(false);
                    }
                    ZScore.this.change();
                    break;
                }
            }
        }
    }

    public class pushButton
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent arg0) {
            JButton push = (JButton)arg0.getSource();
            int index = 0;
            for (int i = 0; i < ZScore.this.m_Over.length; ++i) {
                if (!ZScore.this.m_Over[i].shortName().equals(push.getText())) continue;
                index = i;
                break;
            }
            JColorChooser choose = new JColorChooser();
            Color newCol = JColorChooser.showDialog((Component)((Object)ZScore.this), "Choose overlay color", ZScore.this.m_Over[index].getColor());
            if (newCol != null) {
                AbstractZScoreOverlay[] temp = (AbstractZScoreOverlay[])ZScore.this.m_PanelOverlay.getCurrent();
                temp[index].setColor(newCol);
                ZScore.this.m_PanelOverlay.setCurrent((Object)temp);
                ZScore.this.m_Over[index].setColor(newCol);
                ZScore.this.changeKey();
            }
        }
    }

    public class gridListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent e) {
            JCheckBox check = (JCheckBox)e.getSource();
            if (check.isSelected()) {
                ZScore.this.m_Plot.getLeft().setShowGridLines(true);
                ZScore.this.m_Plot.getBottom().setShowGridLines(true);
                ZScore.this.m_Plot.setGridColor(Color.LIGHT_GRAY);
            } else {
                ZScore.this.m_Plot.getLeft().setShowGridLines(false);
                ZScore.this.m_Plot.getBottom().setShowGridLines(false);
            }
            ZScore.this.m_Plot.repaint();
        }
    }
}

