/*
 * Decompiled with CFR 0.152.
 */
package adams.data.imagej.transformer;

import adams.core.annotation.MixedCopyright;
import adams.data.imagej.Image;
import adams.data.imagej.transformer.AbstractImageJTransformer;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;

@MixedCopyright(copyright="2011 Albert Cardona", author="Albert Cardona", url="http://albert.rierol.net/imagej_programming_tutorials.html#How%20to%20automate%20an%20ImageJ%20dialog")
public class PlugInFilter
extends AbstractImageJTransformer {
    private static final long serialVersionUID = 2700141722155551567L;
    protected String m_PlugInFilter;
    protected ij.plugin.filter.PlugInFilter m_ActualFilter;
    protected boolean m_SuppressPlugInDialog;
    protected String m_PlugInOptions;

    public String globalInfo() {
        return "A transformer that allows the use of ImageJ's plug-in filters.\nNotes:\n- the filter must implement 'ij.plugin.filter.PlugInFilter'\n- the filter can pop-up a window to enter additional parameters,\n  the first time it is executed, depending on the filter implementation\n  (you can suppress this with supplying the options manually)\n- the manual options string can be obtained when recording macros\n  in ImageJ\n- the filter must be in the classpath of the application";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "plugInFilter", (Object)"ij.plugin.filter.FFTFilter");
        this.m_OptionManager.add("suppress-plugin-dialog", "suppressPlugInDialog", (Object)false);
        this.m_OptionManager.add("plugin-options", "plugInOptions", (Object)"");
    }

    protected void reset() {
        super.reset();
        this.m_ActualFilter = null;
    }

    public void setPlugInFilter(String value) {
        this.m_PlugInFilter = value;
        this.reset();
    }

    public String getPlugInFilter() {
        return this.m_PlugInFilter;
    }

    public String plugInFilterTipText() {
        return "The classname of the plug-in filter to use.";
    }

    public void setSuppressPlugInDialog(boolean value) {
        this.m_SuppressPlugInDialog = value;
        this.reset();
    }

    public boolean getSuppressPlugInDialog() {
        return this.m_SuppressPlugInDialog;
    }

    public String suppressPlugInDialogTipText() {
        return "If enabled, the plugin dialog is suppressed using the supplied plugin options.";
    }

    public void setPlugInOptions(String value) {
        this.m_PlugInOptions = value;
        this.reset();
    }

    public String getPlugInOptions() {
        return this.m_PlugInOptions;
    }

    public String plugInOptionsTipText() {
        return "The options for the plug-in if the dialog gets suppressed.";
    }

    protected ij.plugin.filter.PlugInFilter getFilter(Image img) {
        if (this.m_ActualFilter == null) {
            try {
                this.m_ActualFilter = (ij.plugin.filter.PlugInFilter)Class.forName(this.m_PlugInFilter).newInstance();
                int ijResult = this.m_ActualFilter.setup(this.m_PlugInOptions, img.getImage());
                if (ijResult != 0) {
                    img.getNotes().addError(this.getClass(), "ImageJ call of '" + this.m_PlugInFilter + ".setup(...)' returned " + ijResult);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to instantiate ImageJ plugin filter '" + this.m_PlugInFilter + "'!", e);
            }
        }
        return this.m_ActualFilter;
    }

    @Override
    protected Image[] doTransform(Image img) {
        if (this.m_SuppressPlugInDialog) {
            Thread thread = Thread.currentThread();
            String threadName = thread.getName();
            thread.setName("Run$_" + this.hashCode());
            Macro.setOptions((Thread)thread, (String)this.m_PlugInOptions);
            IJ.runPlugIn((ImagePlus)img.getImage(), (String)this.m_PlugInFilter, (String)"");
            Macro.setOptions((Thread)thread, null);
            thread.setName(threadName);
        } else {
            ij.plugin.filter.PlugInFilter filter = this.getFilter(img);
            filter.run(img.getImage().getProcessor());
        }
        return new Image[]{img};
    }

    @Override
    public void cleanUp() {
        WindowManager.closeAllWindows();
        super.cleanUp();
    }
}

