/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.template.engine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jopendocument.dom.template.TemplateException;
import org.jopendocument.dom.template.engine.DataModel;
import org.jopendocument.dom.template.engine.Material;
import org.jopendocument.dom.template.engine.Processor;
import org.jopendocument.dom.template.statements.ForEach;
import org.jopendocument.dom.template.statements.If;
import org.jopendocument.dom.template.statements.Include;
import org.jopendocument.dom.template.statements.SetStmt;
import org.jopendocument.dom.template.statements.Statement;
import org.jopendocument.util.JDOMUtils;

public class Parsed<E> {
    private final Material<E> src;
    private final Map<String, Statement> statements;

    private static Set<Statement> createDefaultStatements() {
        HashSet<Statement> hashSet = new HashSet<Statement>();
        hashSet.add(new ForEach());
        hashSet.add(new If());
        hashSet.add(new SetStmt());
        hashSet.add(new Include());
        return hashSet;
    }

    public Parsed(Material<E> material) throws TemplateException {
        this(material, Parsed.createDefaultStatements());
    }

    public Parsed(Material<E> material, Parsed<?> parsed) throws TemplateException {
        this(material, new HashSet<Statement>(parsed.statements.values()));
    }

    public Parsed(Material<E> material, Set<Statement> set) throws TemplateException {
        this.src = material;
        this.statements = new HashMap<String, Statement>(set.size());
        for (Statement statement : set) {
            this.statements.put(statement.getName(), statement);
        }
        this.prepare(set);
    }

    private void prepare(Set<Statement> set) throws TemplateException {
        if (this.src.hasRoot()) {
            LinkedHashMap<Object, Statement> linkedHashMap = new LinkedHashMap<Object, Statement>();
            Iterator iterator = this.src.getRoot().getDescendants(new ElementFilter());
            block2: while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                for (Statement statement : set) {
                    if (!statement.matches(element)) continue;
                    linkedHashMap.put(element, statement);
                    continue block2;
                }
            }
            for (Object object : linkedHashMap.keySet()) {
                try {
                    ((Statement)linkedHashMap.get(object)).prepare((Element)object);
                }
                catch (Exception exception) {
                    throw new TemplateException("Couldn't prepare " + JDOMUtils.output((Element)object), exception);
                }
            }
        }
    }

    public Material<E> getSource() {
        return this.src;
    }

    public Statement getStatement(String string) {
        return this.statements.get(string);
    }

    public E execute(DataModel dataModel) throws TemplateException {
        if (!this.getSource().hasRoot()) {
            return this.getSource().getWhole();
        }
        return new Processor(this, dataModel).process().getWhole();
    }
}

