/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.encoding;

import de.intarsys.pdf.encoding.Encoding;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class MappedWriter
extends Writer {
    private Encoding encoding;
    private OutputStream outStream;

    public MappedWriter(OutputStream out, Encoding encoding) {
        super(out);
        this.setOutStream(out);
        this.setEncoding(encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.outStream == null) {
                return;
            }
            this.flush();
            this.outStream.close();
            this.outStream = null;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.outStream == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.outStream.flush();
        }
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    protected OutputStream getOutStream() {
        return this.outStream;
    }

    private void setEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    private void setOutStream(OutputStream newOutStream) {
        this.outStream = newOutStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            int stop = off + len;
            int i = off;
            while (i < stop) {
                this.encoding.putNextDecoded(this.outStream, cbuf[i]);
                ++i;
            }
        }
    }
}

