/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDMarkupAnnotation;
import java.util.Iterator;

public class PDPolylineAnnotation
extends PDMarkupAnnotation {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());

    public PDPolylineAnnotation(COSObject object) {
        super(object);
    }

    protected COSName cosGetExpectedSubtype() {
        return PDMarkupAnnotation.CN_Subtype_PolyLine;
    }

    public float getMinHeight() {
        float width = this.getBorderStyleWidth();
        return width;
    }

    public float getMinWidth() {
        float width = this.getBorderStyleWidth();
        return width;
    }

    protected void updateStateRectangle(CDSRectangle oldRectangle, CDSRectangle newRectangle) {
        COSArray vertices = this.cosGetField(PDMarkupAnnotation.DK_Vertices).asArray();
        if (vertices == null) {
            return;
        }
        double oldX = oldRectangle.getLowerLeftX();
        double oldY = oldRectangle.getLowerLeftY();
        double oldWidth = oldRectangle.getWidth();
        double oldHeight = oldRectangle.getHeight();
        double dX = (double)newRectangle.getLowerLeftX() - oldX;
        double dY = (double)newRectangle.getLowerLeftY() - oldY;
        double fX = (double)newRectangle.getWidth() / oldWidth;
        double fY = (double)newRectangle.getHeight() / oldHeight;
        COSArray newVertices = COSArray.create();
        this.cosSetField(PDMarkupAnnotation.DK_Vertices, newVertices);
        if (vertices == null) {
            return;
        }
        Iterator itVertices = vertices.iterator();
        while (itVertices.hasNext()) {
            COSNumber cosX = ((COSObject)itVertices.next()).asNumber();
            if (!itVertices.hasNext()) break;
            COSNumber cosY = ((COSObject)itVertices.next()).asNumber();
            if (cosX == null || cosY == null) continue;
            float x = cosX.floatValue();
            float y = cosY.floatValue();
            newVertices.add(COSFixed.create((float)(((double)x - oldX) * fX + oldX + dX)));
            newVertices.add(COSFixed.create((float)(((double)y - oldY) * fY + oldY + dY)));
        }
    }

    public static class MetaClass
    extends PDMarkupAnnotation.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDPolylineAnnotation(object);
        }
    }
}

