/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeTools;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeType;
import de.intarsys.nativec.type.NativeWideStringType;

public class NativeWideString
extends NativeObject {
    public static final NativeWideStringType META = new NativeWideStringType();
    private int size = 0;
    private NativeWideStringType type;

    static {
        NativeType.register(NativeWideString.class, META);
    }

    public static NativeWideString createFromAddress(long address) {
        return (NativeWideString)META.createNative(NativeTools.toHandle(address));
    }

    protected NativeWideString(NativeWideStringType pType) {
        this.type = pType;
        this.allocate();
    }

    protected NativeWideString(NativeWideStringType pType, INativeHandle handle) {
        super(handle);
        this.type = pType;
        if (this.type.hasByteCount()) {
            handle.setSize(this.type.getByteCount());
        }
    }

    protected NativeWideString(NativeWideStringType pType, String value) {
        this.type = pType;
        if (this.type.getStringSize() == 0) {
            this.size = value.length() + 1;
            this.size <<= 1;
        }
        this.allocate();
        this.setValue(value);
    }

    public NativeWideString(String value) {
        this(META, value);
    }

    public int getByteCount() {
        if (this.type.hasByteCount()) {
            return this.type.getByteCount();
        }
        return this.size;
    }

    public INativeType getNativeType() {
        return this.type;
    }

    public Object getValue() {
        return this.stringValue();
    }

    public void setValue(Object value) {
        this.setValue((String)value);
    }

    public void setValue(String value) {
        this.size = value.length() + 1;
        this.size <<= 1;
        this.handle.setWideString(0, value);
    }

    public String stringValue() {
        return this.handle.getWideString(0);
    }
}

