/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.cwt.font.truetype.CreateSubset;
import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTFontSerializer;
import de.intarsys.cwt.font.truetype.TrueTypeException;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontDescriptorEmbedded;
import de.intarsys.pdf.font.PDFontTrueType;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.platform.cwt.font.PlatformFontTools;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFontTrueTypeTools {
    private static final Attribute ATTR_CWTFONT = new Attribute("cwtfont");

    protected static TTFont basicSubset(PDFont pdFont, TTFont ttFont, Set<Integer> indices) throws IOException {
        TTFont newFont;
        CreateSubset tool = new CreateSubset(ttFont, indices);
        try {
            newFont = tool.compute();
        }
        catch (TrueTypeException e) {
            newFont = ttFont;
        }
        RandomAccessByteArray random = new RandomAccessByteArray(null);
        TTFontSerializer serializer = new TTFontSerializer();
        serializer.write((IRandomAccess)random, newFont);
        pdFont.getFontDescriptor().setFontFile2(random.toByteArray());
        return newFont;
    }

    protected static void embedFontFile(PDFont font, ILocator locator) throws IOException {
        InputStream is = locator.getInputStream();
        try {
            byte[] data = StreamTools.toByteArray((InputStream)is);
            ((PDFontDescriptorEmbedded)font.getFontDescriptor()).setFontFile2(data);
        }
        finally {
            StreamTools.close((InputStream)is);
        }
        PDFontTrueTypeTools.subset(font);
    }

    public static TTFont getTTFont(PDFont pdFont) {
        TTFont ttFont = (TTFont)pdFont.getAttribute((Object)ATTR_CWTFONT);
        if (ttFont != null) {
            return ttFont;
        }
        ILocator locator = PlatformFontTools.getFontFile(pdFont);
        if (locator == null) {
            return null;
        }
        try {
            ttFont = TTFont.createFromLocator((ILocator)locator);
            PDFontTrueTypeTools.setTTFont(pdFont, ttFont);
            return ttFont;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected static Map getTTFontCMap(PDFont pdFont) throws TrueTypeException {
        TTFont ttFont = PDFontTrueTypeTools.getTTFont(pdFont);
        Map result = null;
        PDFontDescriptor fontDescriptor = null;
        try {
            fontDescriptor = pdFont.getFontDescriptor();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        result = fontDescriptor == null ? ttFont.getCMapsAt(3, 1) : (fontDescriptor.isSymbolic() ? ttFont.getCMapsAt(3, 0) : ttFont.getCMapsAt(3, 1));
        if (result == null) {
            throw new TrueTypeException("No suitable CMap found");
        }
        return result;
    }

    public static void setTTFont(PDFont pdFont, TTFont ttFont) {
        pdFont.setAttribute((Object)ATTR_CWTFONT, (Object)ttFont);
    }

    public static void subset(PDFont pdFont) throws IOException {
        if (!(pdFont instanceof PDFontTrueType)) {
            throw new IllegalArgumentException("subsetting " + pdFont.getClass().getName() + " not supported");
        }
        TTFont ttFont = PDFontTrueTypeTools.getTTFont(pdFont);
        Map cmap = null;
        try {
            cmap = PDFontTrueTypeTools.getTTFontCMap(pdFont);
        }
        catch (TrueTypeException e) {
            return;
        }
        HashSet<Integer> indices = new HashSet<Integer>();
        int first = pdFont.getFirstChar();
        int last = pdFont.getLastChar();
        int i = first;
        while (i <= last) {
            int decoded = pdFont.getEncoding().getDecoded(i);
            Integer index = (Integer)cmap.get(new Integer(decoded));
            if (index != null) {
                indices.add(index);
            }
            ++i;
        }
        TTFont newFont = PDFontTrueTypeTools.basicSubset(pdFont, ttFont, indices);
        PDFontTrueTypeTools.setTTFont(pdFont, newFont);
    }

    public static void subset(PDFont pdFont, Set<PDGlyphs> used) throws IOException, TrueTypeException {
        if (!(pdFont instanceof PDFontTrueType)) {
            throw new IllegalArgumentException("subsetting " + pdFont.getClass().getName() + " not supported");
        }
        TTFont ttFont = PDFontTrueTypeTools.getTTFont(pdFont);
        Map cmap = null;
        try {
            cmap = PDFontTrueTypeTools.getTTFontCMap(pdFont);
        }
        catch (TrueTypeException e) {
            return;
        }
        HashSet<Integer> indices = new HashSet<Integer>();
        for (PDGlyphs pdGlyphs : used) {
            int decoded = pdGlyphs.getDecoded();
            Integer index = (Integer)cmap.get(new Integer(decoded));
            if (index == null) continue;
            indices.add(index);
        }
        TTFont newFont = PDFontTrueTypeTools.basicSubset(pdFont, ttFont, indices);
        PDFontTrueTypeTools.setTTFont(pdFont, newFont);
    }
}

