/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest.httpclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ObjectsChunk;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.impl.rest.HttpException;
import org.jets3t.service.impl.rest.XmlResponsesSaxParser;
import org.jets3t.service.impl.rest.httpclient.AWSRequestAuthorizer;
import org.jets3t.service.impl.rest.httpclient.HttpClientAndConnectionManager;
import org.jets3t.service.impl.rest.httpclient.HttpMethodReleaseInputStream;
import org.jets3t.service.impl.rest.httpclient.RepeatableRequestEntity;
import org.jets3t.service.model.CreateBucketConfiguration;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3BucketLoggingStatus;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.model.S3Owner;
import org.jets3t.service.mx.MxDelegate;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.utils.RestUtils;
import org.jets3t.service.utils.ServiceUtils;
import org.jets3t.service.utils.signedurl.SignedUrlHandler;

public class RestS3Service
extends S3Service
implements SignedUrlHandler,
AWSRequestAuthorizer {
    private static final long serialVersionUID = 3481768088915480629L;
    private static final Log log = LogFactory.getLog((Class)RestS3Service.class);
    protected HttpClient httpClient = null;
    protected HttpConnectionManager connectionManager = null;
    protected CredentialsProvider credentialsProvider = null;

    public RestS3Service(AWSCredentials awsCredentials) throws S3ServiceException {
        this(awsCredentials, (String)null, (CredentialsProvider)null);
    }

    public RestS3Service(AWSCredentials awsCredentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider) throws S3ServiceException {
        this(awsCredentials, invokingApplicationDescription, credentialsProvider, Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME));
    }

    public RestS3Service(AWSCredentials awsCredentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties) throws S3ServiceException {
        this(awsCredentials, invokingApplicationDescription, credentialsProvider, jets3tProperties, new HostConfiguration());
    }

    public RestS3Service(AWSCredentials awsCredentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties, HostConfiguration hostConfig) throws S3ServiceException {
        super(awsCredentials, invokingApplicationDescription, jets3tProperties);
        this.credentialsProvider = credentialsProvider;
        HttpClientAndConnectionManager initHttpResult = this.initHttpConnection(hostConfig);
        this.httpClient = initHttpResult.getHttpClient();
        this.connectionManager = initHttpResult.getHttpConnectionManager();
        this.setRequesterPaysEnabled(this.jets3tProperties.getBoolProperty("httpclient.requester-pays-buckets-enabled", false));
        if (this.jets3tProperties.getBoolProperty("httpclient.proxy-autodetect", true)) {
            RestUtils.initHttpProxy(this.httpClient);
        } else {
            String proxyHostAddress = this.jets3tProperties.getStringProperty("httpclient.proxy-host", null);
            int proxyPort = this.jets3tProperties.getIntProperty("httpclient.proxy-port", -1);
            String proxyUser = this.jets3tProperties.getStringProperty("httpclient.proxy-user", null);
            String proxyPassword = this.jets3tProperties.getStringProperty("httpclient.proxy-password", null);
            String proxyDomain = this.jets3tProperties.getStringProperty("httpclient.proxy-domain", null);
            RestUtils.initHttpProxy(this.httpClient, proxyHostAddress, proxyPort, proxyUser, proxyPassword, proxyDomain);
        }
    }

    protected HttpClientAndConnectionManager initHttpConnection(HostConfiguration hostConfig) {
        return RestUtils.initHttpConnection(this, hostConfig, this.jets3tProperties, this.getInvokingApplicationDescription(), this.credentialsProvider);
    }

    public HttpConnectionManager getHttpConnectionManager() {
        return this.connectionManager;
    }

    public void setHttpConnectionManager(HttpConnectionManager httpConnectionManager) {
        this.connectionManager = httpConnectionManager;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    protected boolean isXmlContentType(String contentType) {
        return contentType != null && contentType.toLowerCase().startsWith("application/xml".toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRequest(HttpMethodBase httpMethod, int[] expectedResponseCodes) throws S3ServiceException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Performing " + httpMethod.getName() + " request for '" + httpMethod.getURI().toString() + "', expecting response codes: " + "[" + ServiceUtils.join(expectedResponseCodes, ",") + "]"));
            }
            boolean completedWithoutRecoverableError = true;
            int internalErrorCount = 0;
            int requestTimeoutErrorCount = 0;
            int redirectCount = 0;
            boolean wasRecentlyRedirected = false;
            int responseCode = -1;
            do {
                if (!wasRecentlyRedirected) {
                    this.authorizeHttpRequest((HttpMethod)httpMethod);
                } else {
                    wasRecentlyRedirected = false;
                }
                responseCode = this.httpClient.executeMethod((HttpMethod)httpMethod);
                if (responseCode == 307) {
                    Header locationHeader = httpMethod.getResponseHeader("location");
                    httpMethod.setURI(new URI(locationHeader.getValue(), true));
                    completedWithoutRecoverableError = false;
                    wasRecentlyRedirected = true;
                    if (++redirectCount > 5) {
                        throw new S3ServiceException("Encountered too many 307 Redirects, aborting request.");
                    }
                } else if (responseCode == 500 || responseCode == 503) {
                    completedWithoutRecoverableError = false;
                    this.sleepOnInternalError(++internalErrorCount);
                } else {
                    completedWithoutRecoverableError = true;
                }
                String contentType = "";
                if (httpMethod.getResponseHeader("Content-Type") != null) {
                    contentType = httpMethod.getResponseHeader("Content-Type").getValue();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Response for '" + httpMethod.getPath() + "'. Content-Type: " + contentType + ", Headers: " + Arrays.asList(httpMethod.getResponseHeaders())));
                }
                boolean didReceiveExpectedResponseCode = false;
                for (int i = 0; i < expectedResponseCodes.length && !didReceiveExpectedResponseCode; ++i) {
                    if (responseCode != expectedResponseCodes[i]) continue;
                    didReceiveExpectedResponseCode = true;
                }
                if (didReceiveExpectedResponseCode) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Response '" + httpMethod.getPath() + "' - Unexpected response code " + responseCode + ", expected [" + ServiceUtils.join(expectedResponseCodes, ",") + "]"));
                }
                if (this.isXmlContentType(contentType) && httpMethod.getResponseBodyAsStream() != null && httpMethod.getResponseContentLength() != 0L) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Response '" + httpMethod.getPath() + "' - Received error response with XML message"));
                    }
                    StringBuffer sb = new StringBuffer();
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            sb.append(line + "\n");
                        }
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    httpMethod.releaseConnection();
                    S3ServiceException exception = new S3ServiceException("S3 " + httpMethod.getName() + " failed for '" + httpMethod.getPath() + "'", sb.toString());
                    if ("RequestTimeout".equals(exception.getS3ErrorCode())) {
                        int retryMaxCount = this.jets3tProperties.getIntProperty("httpclient.retry-max", 5);
                        if (requestTimeoutErrorCount < retryMaxCount) {
                            ++requestTimeoutErrorCount;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Response '" + httpMethod.getPath() + "' - Retrying connection that failed with RequestTimeout error" + ", attempt number " + requestTimeoutErrorCount + " of " + retryMaxCount));
                            }
                            completedWithoutRecoverableError = false;
                            continue;
                        }
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("Response '" + httpMethod.getPath() + "' - Exceeded maximum number of retries for RequestTimeout errors: " + retryMaxCount));
                        }
                        throw exception;
                    }
                    if ("RequestTimeTooSkewed".equals(exception.getS3ErrorCode())) {
                        this.timeOffset = RestUtils.getAWSTimeAdjustment();
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("Adjusted time offset in response to RequestTimeTooSkewed error. Local machine and S3 server disagree on the time by approximately " + this.timeOffset / 1000L + " seconds. Retrying connection."));
                        }
                        completedWithoutRecoverableError = false;
                        continue;
                    }
                    if (responseCode == 500 || responseCode == 503) continue;
                    if (responseCode == 307) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Following Temporary Redirect to: " + httpMethod.getURI().toString()));
                        continue;
                    }
                    throw exception;
                }
                String responseText = null;
                byte[] responseBody = httpMethod.getResponseBody();
                if (responseBody != null && responseBody.length > 0) {
                    responseText = new String(responseBody);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Releasing error response without XML content");
                }
                httpMethod.releaseConnection();
                if (responseCode == 500 || responseCode == 503) continue;
                HttpException httpException = new HttpException(httpMethod.getStatusCode(), httpMethod.getStatusText());
                S3ServiceException exception = new S3ServiceException("S3 " + httpMethod.getName() + " request failed for '" + httpMethod.getPath() + "' - " + "ResponseCode=" + httpMethod.getStatusCode() + ", ResponseMessage=" + httpMethod.getStatusText() + (responseText != null ? "\n" + responseText : ""), httpException);
                exception.setResponseCode(httpMethod.getStatusCode());
                exception.setResponseStatus(httpMethod.getStatusText());
                throw exception;
            } while (!completedWithoutRecoverableError);
            if ((httpMethod.getResponseBodyAsStream() == null || httpMethod.getResponseBodyAsStream().available() == 0) && httpMethod.getResponseContentLength() == 0L) {
                byte[] responseBody;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Releasing response without content");
                }
                if ((responseBody = httpMethod.getResponseBody()) != null && responseBody.length > 0) {
                    throw new S3ServiceException("Oops, too keen to release connection with a non-empty response body");
                }
                httpMethod.releaseConnection();
            }
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Releasing HttpClient connection after error: " + t.getMessage()));
            }
            httpMethod.releaseConnection();
            if (t instanceof S3ServiceException) {
                throw (S3ServiceException)t;
            }
            MxDelegate.getInstance().registerS3ServiceExceptionEvent();
            throw new S3ServiceException("S3 " + httpMethod.getName() + " connection failed for '" + httpMethod.getPath() + "'", t);
        }
    }

    public void authorizeHttpRequest(HttpMethod httpMethod) throws Exception {
        String queryString;
        String hostname;
        block9: {
            if (this.getAWSCredentials() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding authorization for AWS Access Key '" + this.getAWSCredentials().getAccessKey() + "'."));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Service has no AWS Credential and is un-authenticated, skipping authorization");
                }
                return;
            }
            hostname = null;
            try {
                hostname = httpMethod.getURI().getHost();
            }
            catch (URIException e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Unable to determine hostname target for request", (Throwable)e);
            }
        }
        String fullUrl = httpMethod.getPath();
        if (!Constants.S3_HOSTNAME.equals(hostname)) {
            int subdomainOffset = hostname.lastIndexOf("." + Constants.S3_HOSTNAME);
            fullUrl = subdomainOffset > 0 ? "/" + hostname.substring(0, subdomainOffset) + httpMethod.getPath() : "/" + hostname + httpMethod.getPath();
        }
        if ((queryString = httpMethod.getQueryString()) != null && queryString.length() > 0) {
            fullUrl = fullUrl + "?" + queryString;
        }
        httpMethod.setRequestHeader("Date", ServiceUtils.formatRfc822Date(this.getCurrentTimeWithOffset()));
        String canonicalString = RestUtils.makeS3CanonicalString(httpMethod.getName(), fullUrl, this.convertHeadersToMap(httpMethod.getRequestHeaders()), null);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Canonical string ('|' is a newline): " + canonicalString.replace('\n', '|')));
        }
        String signedCanonical = ServiceUtils.signWithHmacSha1(this.getAWSCredentials().getSecretKey(), canonicalString);
        String authorizationString = "AWS " + this.getAWSCredentials().getAccessKey() + ":" + signedCanonical;
        httpMethod.setRequestHeader("Authorization", authorizationString);
    }

    protected String addRequestParametersToUrlPath(String urlPath, Map requestParameters) throws S3ServiceException {
        if (requestParameters != null) {
            Iterator reqPropIter = requestParameters.entrySet().iterator();
            while (reqPropIter.hasNext()) {
                Map.Entry entry = reqPropIter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                urlPath = urlPath + (urlPath.indexOf("?") < 0 ? "?" : "&") + RestUtils.encodeUrlString(key.toString());
                if (value != null && value.toString().length() > 0) {
                    urlPath = urlPath + "=" + RestUtils.encodeUrlString(value.toString());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Added request parameter: " + key + "=" + value));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Added request parameter without value: " + key));
            }
        }
        return urlPath;
    }

    protected void addRequestHeadersToConnection(HttpMethodBase httpMethod, Map requestHeaders) {
        if (requestHeaders != null) {
            Iterator reqHeaderIter = requestHeaders.entrySet().iterator();
            while (reqHeaderIter.hasNext()) {
                Map.Entry entry = reqHeaderIter.next();
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                httpMethod.setRequestHeader(key, value);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Added request header to connection: " + key + "=" + value));
            }
        }
    }

    private Map convertHeadersToMap(Header[] headers) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; headers != null && i < headers.length; ++i) {
            map.put(headers[i].getName(), headers[i].getValue());
        }
        return map;
    }

    private void addMetadataToHeaders(HttpMethodBase httpMethod, Map metadata) {
        Iterator metaDataIter = metadata.entrySet().iterator();
        while (metaDataIter.hasNext()) {
            Map.Entry entry = metaDataIter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key == null || !(value instanceof String)) continue;
            httpMethod.setRequestHeader(key, (String)value);
        }
    }

    protected HttpMethodBase performRestHead(String bucketName, String objectKey, Map requestParameters, Map requestHeaders) throws S3ServiceException {
        HttpMethodBase httpMethod = this.setupConnection("HEAD", bucketName, objectKey, requestParameters);
        this.addRequestHeadersToConnection(httpMethod, requestHeaders);
        this.performRequest(httpMethod, new int[]{200});
        return httpMethod;
    }

    protected HttpMethodBase performRestGet(String bucketName, String objectKey, Map requestParameters, Map requestHeaders) throws S3ServiceException {
        HttpMethodBase httpMethod = this.setupConnection("GET", bucketName, objectKey, requestParameters);
        this.addRequestHeadersToConnection(httpMethod, requestHeaders);
        int expectedStatusCode = 200;
        if (requestHeaders != null && requestHeaders.containsKey("Range")) {
            expectedStatusCode = 206;
        }
        this.performRequest(httpMethod, new int[]{expectedStatusCode});
        return httpMethod;
    }

    protected HttpMethodAndByteCount performRestPut(String bucketName, String objectKey, Map metadata, Map requestParameters, RequestEntity requestEntity, boolean autoRelease) throws S3ServiceException {
        HttpMethodBase httpMethod = this.setupConnection("PUT", bucketName, objectKey, requestParameters);
        Map renamedMetadata = RestUtils.renameMetadataKeys(metadata);
        this.addMetadataToHeaders(httpMethod, renamedMetadata);
        long contentLength = 0L;
        if (requestEntity != null) {
            ((PutMethod)httpMethod).setRequestEntity(requestEntity);
        } else {
            httpMethod.setRequestHeader("Content-Length", "0");
        }
        this.performRequest(httpMethod, new int[]{200});
        if (requestEntity != null) {
            contentLength = ((PutMethod)httpMethod).getRequestEntity().getContentLength();
        }
        if (autoRelease) {
            httpMethod.releaseConnection();
        }
        return new HttpMethodAndByteCount(httpMethod, contentLength);
    }

    protected HttpMethodBase performRestDelete(String bucketName, String objectKey) throws S3ServiceException {
        HttpMethodBase httpMethod = this.setupConnection("DELETE", bucketName, objectKey, null);
        this.performRequest(httpMethod, new int[]{204, 200});
        if (log.isDebugEnabled()) {
            log.debug((Object)"Releasing HttpMethod after delete");
        }
        httpMethod.releaseConnection();
        return httpMethod;
    }

    protected HttpMethodBase setupConnection(String method, String bucketName, String objectKey, Map requestParameters) throws S3ServiceException {
        if (bucketName == null) {
            throw new S3ServiceException("Cannot connect to S3 Service with a null path");
        }
        boolean disableDnsBuckets = this.jets3tProperties.getBoolProperty("s3service.disable-dns-buckets", false);
        String hostname = RestS3Service.generateS3HostnameForBucket(bucketName, disableDnsBuckets);
        String virtualPath = this.jets3tProperties.getStringProperty("s3service.s3-endpoint-virtual-path", "");
        String resourceString = "/";
        if (hostname.equals(Constants.S3_HOSTNAME) && bucketName != null && bucketName.length() > 0) {
            resourceString = resourceString + bucketName + "/";
        }
        resourceString = resourceString + (objectKey != null ? RestUtils.encodeUrlString(objectKey) : "");
        String url = null;
        if (this.isHttpsOnly()) {
            int securePort = this.jets3tProperties.getIntProperty("s3service.s3-endpoint-https-port", 443);
            url = "https://" + hostname + ":" + securePort + virtualPath + resourceString;
        } else {
            int insecurePort = this.jets3tProperties.getIntProperty("s3service.s3-endpoint-http-port", 80);
            url = "http://" + hostname + ":" + insecurePort + virtualPath + resourceString;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("S3 URL: " + url));
        }
        url = this.addRequestParametersToUrlPath(url, requestParameters);
        PutMethod httpMethod = null;
        if ("PUT".equals(method)) {
            httpMethod = new PutMethod(url);
        } else if ("HEAD".equals(method)) {
            httpMethod = new HeadMethod(url);
        } else if ("GET".equals(method)) {
            httpMethod = new GetMethod(url);
        } else if ("DELETE".equals(method)) {
            httpMethod = new DeleteMethod(url);
        } else {
            throw new IllegalArgumentException("Unrecognised HTTP method name: " + method);
        }
        if (httpMethod.getRequestHeader("Date") == null) {
            httpMethod.setRequestHeader("Date", ServiceUtils.formatRfc822Date(this.getCurrentTimeWithOffset()));
        }
        if (httpMethod.getRequestHeader("Content-Type") == null) {
            httpMethod.setRequestHeader("Content-Type", "");
        }
        if (this.getDevPayUserToken() != null || this.getDevPayProductToken() != null) {
            if (this.getDevPayProductToken() != null) {
                String securityToken = this.getDevPayUserToken() + "," + this.getDevPayProductToken();
                httpMethod.setRequestHeader("x-amz-security-token", securityToken);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Including DevPay user and product tokens in request: x-amz-security-token=" + securityToken));
                }
            } else {
                httpMethod.setRequestHeader("x-amz-security-token", this.getDevPayUserToken());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Including DevPay user token in request: x-amz-security-token=" + this.getDevPayUserToken()));
                }
            }
        }
        if (this.isRequesterPaysEnabled()) {
            String[] requesterPaysHeaderAndValue = "x-amz-request-payer=requester".split("=");
            httpMethod.setRequestHeader(requesterPaysHeaderAndValue[0], requesterPaysHeaderAndValue[1]);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Including Requester Pays header in request: x-amz-request-payer=requester");
            }
        }
        return httpMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isBucketAccessible(String bucketName) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking existence of bucket: " + bucketName));
        }
        HttpMethodBase httpMethod = null;
        try {
            block12: {
                try {
                    httpMethod = this.performRestHead(bucketName, null, null, null);
                    if (httpMethod.getResponseBodyAsStream() == null) break block12;
                    httpMethod.getResponseBodyAsStream().close();
                }
                catch (S3ServiceException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Bucket does not exist: " + bucketName), (Throwable)e);
                    }
                    boolean bl = false;
                    Object var6_4 = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Releasing un-wanted bucket HEAD response");
                    }
                    if (httpMethod == null) return bl;
                    httpMethod.releaseConnection();
                    return bl;
                }
                catch (IOException e) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Unable to close response body input stream", (Throwable)e);
                    }
                    Object var6_5 = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Releasing un-wanted bucket HEAD response");
                    }
                    if (httpMethod == null) return true;
                    httpMethod.releaseConnection();
                    return true;
                }
            }
            Object var6_3 = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Releasing un-wanted bucket HEAD response");
            }
            if (httpMethod == null) return true;
            httpMethod.releaseConnection();
            return true;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Releasing un-wanted bucket HEAD response");
            }
            if (httpMethod == null) throw throwable;
            httpMethod.releaseConnection();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int checkBucketStatus(String bucketName) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking availability of bucket name: " + bucketName));
        }
        HttpMethodBase httpMethod = null;
        try {
            block15: {
                try {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("max-keys", "0");
                    httpMethod = this.performRestHead(bucketName, null, params, null);
                    if (httpMethod.getResponseBodyAsStream() == null) break block15;
                    httpMethod.getResponseBodyAsStream().close();
                }
                catch (S3ServiceException e) {
                    if (e.getResponseCode() == 403) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Bucket named '" + bucketName + "' already belongs to another S3 user"));
                        }
                        int n = 2;
                        Object var6_7 = null;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Releasing un-wanted bucket HEAD response");
                        }
                        if (httpMethod == null) return n;
                        httpMethod.releaseConnection();
                        return n;
                    }
                    if (e.getResponseCode() != 404) throw e;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Bucket does not exist: " + bucketName), (Throwable)e);
                    }
                    int n = 1;
                    Object var6_8 = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Releasing un-wanted bucket HEAD response");
                    }
                    if (httpMethod == null) return n;
                    httpMethod.releaseConnection();
                    return n;
                }
                catch (IOException e) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Unable to close response body input stream", (Throwable)e);
                    }
                    Object var6_9 = null;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Releasing un-wanted bucket HEAD response");
                    }
                    if (httpMethod == null) return 0;
                    httpMethod.releaseConnection();
                    return 0;
                }
            }
            Object var6_6 = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Releasing un-wanted bucket HEAD response");
            }
            if (httpMethod == null) return 0;
            httpMethod.releaseConnection();
            return 0;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Releasing un-wanted bucket HEAD response");
            }
            if (httpMethod == null) throw throwable;
            httpMethod.releaseConnection();
            throw throwable;
        }
    }

    protected S3Bucket[] listAllBucketsImpl() throws S3ServiceException {
        String bucketName;
        HttpMethodBase httpMethod;
        String contentType;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Listing all buckets for AWS user: " + this.getAWSCredentials().getAccessKey()));
        }
        if (!this.isXmlContentType(contentType = (httpMethod = this.performRestGet(bucketName = "", null, null, null)).getResponseHeader("Content-Type").getValue())) {
            throw new S3ServiceException("Expected XML document response from S3 but received content type " + contentType);
        }
        S3Bucket[] buckets = new XmlResponsesSaxParser(this.jets3tProperties).parseListMyBucketsResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)).getBuckets();
        return buckets;
    }

    protected S3Owner getAccountOwnerImpl() throws S3ServiceException {
        String bucketName;
        HttpMethodBase httpMethod;
        String contentType;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking up owner of S3 account via the ListAllBuckets response: " + this.getAWSCredentials().getAccessKey()));
        }
        if (!this.isXmlContentType(contentType = (httpMethod = this.performRestGet(bucketName = "", null, null, null)).getResponseHeader("Content-Type").getValue())) {
            throw new S3ServiceException("Expected XML document response from S3 but received content type " + contentType);
        }
        S3Owner owner = new XmlResponsesSaxParser(this.jets3tProperties).parseListMyBucketsResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)).getOwner();
        return owner;
    }

    protected S3Object[] listObjectsImpl(String bucketName, String prefix, String delimiter, long maxListingLength) throws S3ServiceException {
        return this.listObjectsInternal(bucketName, prefix, delimiter, maxListingLength, true, null).getObjects();
    }

    protected S3ObjectsChunk listObjectsChunkedImpl(String bucketName, String prefix, String delimiter, long maxListingLength, String priorLastKey, boolean completeListing) throws S3ServiceException {
        return this.listObjectsInternal(bucketName, prefix, delimiter, maxListingLength, completeListing, priorLastKey);
    }

    protected S3ObjectsChunk listObjectsInternal(String bucketName, String prefix, String delimiter, long maxListingLength, boolean automaticallyMergeChunks, String priorLastKey) throws S3ServiceException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (prefix != null) {
            parameters.put("prefix", prefix);
        }
        if (delimiter != null) {
            parameters.put("delimiter", delimiter);
        }
        if (maxListingLength > 0L) {
            parameters.put("max-keys", String.valueOf(maxListingLength));
        }
        ArrayList<S3Object> objects = new ArrayList<S3Object>();
        ArrayList<String> commonPrefixes = new ArrayList<String>();
        boolean incompleteListing = true;
        int ioErrorRetryCount = 0;
        while (incompleteListing) {
            if (priorLastKey != null) {
                parameters.put("marker", priorLastKey);
            } else {
                parameters.remove("marker");
            }
            HttpMethodBase httpMethod = this.performRestGet(bucketName, null, parameters, null);
            XmlResponsesSaxParser.ListBucketHandler listBucketHandler = null;
            try {
                listBucketHandler = new XmlResponsesSaxParser(this.jets3tProperties).parseListBucketObjectsResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod));
                ioErrorRetryCount = 0;
            }
            catch (S3ServiceException e) {
                if (e.getCause() instanceof IOException && ioErrorRetryCount < 5) {
                    ++ioErrorRetryCount;
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)"Retrying bucket listing failure due to IO error", (Throwable)e);
                    continue;
                }
                throw e;
            }
            S3Object[] partialObjects = listBucketHandler.getObjects();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + partialObjects.length + " objects in one batch"));
            }
            objects.addAll(Arrays.asList(partialObjects));
            String[] partialCommonPrefixes = listBucketHandler.getCommonPrefixes();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + partialCommonPrefixes.length + " common prefixes in one batch"));
            }
            commonPrefixes.addAll(Arrays.asList(partialCommonPrefixes));
            incompleteListing = listBucketHandler.isListingTruncated();
            if (incompleteListing) {
                priorLastKey = listBucketHandler.getMarkerForNextListing();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Yet to receive complete listing of bucket contents, last key for prior chunk: " + priorLastKey));
                }
            } else {
                priorLastKey = null;
            }
            if (automaticallyMergeChunks) continue;
            break;
        }
        if (automaticallyMergeChunks) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found " + objects.size() + " objects in total"));
            }
            return new S3ObjectsChunk(prefix, delimiter, objects.toArray(new S3Object[objects.size()]), commonPrefixes.toArray(new String[commonPrefixes.size()]), null);
        }
        return new S3ObjectsChunk(prefix, delimiter, objects.toArray(new S3Object[objects.size()]), commonPrefixes.toArray(new String[commonPrefixes.size()]), priorLastKey);
    }

    protected void deleteObjectImpl(String bucketName, String objectKey) throws S3ServiceException {
        this.performRestDelete(bucketName, objectKey);
    }

    protected AccessControlList getObjectAclImpl(String bucketName, String objectKey) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving Access Control List for bucketName=" + bucketName + ", objectKkey=" + objectKey));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("acl", "");
        HttpMethodBase httpMethod = this.performRestGet(bucketName, objectKey, requestParameters, null);
        return new XmlResponsesSaxParser(this.jets3tProperties).parseAccessControlListResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)).getAccessControlList();
    }

    protected AccessControlList getBucketAclImpl(String bucketName) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving Access Control List for Bucket: " + bucketName));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("acl", "");
        HttpMethodBase httpMethod = this.performRestGet(bucketName, null, requestParameters, null);
        return new XmlResponsesSaxParser(this.jets3tProperties).parseAccessControlListResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)).getAccessControlList();
    }

    protected void putObjectAclImpl(String bucketName, String objectKey, AccessControlList acl) throws S3ServiceException {
        this.putAclImpl(bucketName, objectKey, acl);
    }

    protected void putBucketAclImpl(String bucketName, AccessControlList acl) throws S3ServiceException {
        String fullKey = bucketName;
        this.putAclImpl(fullKey, null, acl);
    }

    protected void putAclImpl(String bucketName, String objectKey, AccessControlList acl) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting Access Control List for bucketName=" + bucketName + ", objectKey=" + objectKey));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("acl", "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "text/plain");
        try {
            String aclAsXml = acl.toXml();
            metadata.put("Content-Length", String.valueOf(aclAsXml.length()));
            this.performRestPut(bucketName, objectKey, metadata, requestParameters, (RequestEntity)new StringRequestEntity(aclAsXml, "text/plain", Constants.DEFAULT_ENCODING), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to encode ACL XML document", e);
        }
    }

    protected S3Bucket createBucketImpl(String bucketName, String location, AccessControlList acl) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating bucket with name: " + bucketName));
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        StringRequestEntity requestEntity = null;
        if (location != null && !"US".equalsIgnoreCase(location)) {
            metadata.put("Content-Type", "text/xml");
            try {
                CreateBucketConfiguration config = new CreateBucketConfiguration(location);
                metadata.put("Content-Length", String.valueOf(config.toXml().length()));
                requestEntity = new StringRequestEntity(config.toXml(), "text/xml", Constants.DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                throw new S3ServiceException("Unable to encode CreateBucketConfiguration XML document", e);
            }
        }
        Map map = this.createObjectImpl(bucketName, null, null, (RequestEntity)requestEntity, metadata, acl);
        S3Bucket bucket = new S3Bucket(bucketName, location);
        bucket.setAcl(acl);
        bucket.replaceAllMetadata(map);
        return bucket;
    }

    protected void deleteBucketImpl(String bucketName) throws S3ServiceException {
        this.performRestDelete(bucketName, null);
    }

    protected S3Object putObjectImpl(String bucketName, S3Object object) throws S3ServiceException {
        Map map;
        Object requestEntity;
        boolean isLiveMD5HashingRequired;
        block11: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating Object with key " + object.getKey() + " in bucket " + bucketName));
            }
            isLiveMD5HashingRequired = object.getMetadata("Content-MD5") == null;
            requestEntity = null;
            if (object.getDataInputStream() != null) {
                if (object.containsMetadata("Content-Length")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Uploading object data with Content-Length: " + object.getContentLength()));
                    }
                    requestEntity = new RepeatableRequestEntity(object.getKey(), object.getDataInputStream(), object.getContentType(), object.getContentLength(), this.jets3tProperties, isLiveMD5HashingRequired);
                } else {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"Content-Length of data stream not set, will automatically determine data length in memory");
                    }
                    requestEntity = new InputStreamRequestEntity(object.getDataInputStream(), -2L);
                }
            }
            map = this.createObjectImpl(bucketName, object.getKey(), object.getContentType(), (RequestEntity)requestEntity, object.getMetadataMap(), object.getAcl());
            try {
                object.closeDataInputStream();
            }
            catch (IOException e) {
                if (!log.isWarnEnabled()) break block11;
                log.warn((Object)("Unable to close data input stream for object '" + object.getKey() + "'"), (Throwable)e);
            }
        }
        object.replaceAllMetadata(map);
        if (isLiveMD5HashingRequired && requestEntity instanceof RepeatableRequestEntity) {
            String hexMD5OfUploadedData = ServiceUtils.toHex(((RepeatableRequestEntity)requestEntity).getMD5DigestOfData());
            if (!object.getETag().equals(hexMD5OfUploadedData)) {
                throw new S3ServiceException("Mismatch between MD5 hash of uploaded data (" + hexMD5OfUploadedData + ") and ETag returned by S3 (" + object.getETag() + ") for: " + object.getKey());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Object upload was automatically verified, the calculated MD5 hash value matched the ETag returned by S3: " + object.getKey()));
            }
        }
        return object;
    }

    protected Map createObjectImpl(String bucketName, String objectKey, String contentType, RequestEntity requestEntity, Map metadata, AccessControlList acl) throws S3ServiceException {
        metadata = metadata == null ? new HashMap<String, String>() : new HashMap(metadata);
        if (contentType != null) {
            metadata.put("Content-Type", contentType);
        } else {
            metadata.put("Content-Type", "application/octet-stream");
        }
        boolean putNonStandardAcl = false;
        if (acl != null) {
            if (AccessControlList.REST_CANNED_PRIVATE.equals(acl)) {
                metadata.put("x-amz-acl", "private");
            } else if (AccessControlList.REST_CANNED_PUBLIC_READ.equals(acl)) {
                metadata.put("x-amz-acl", "public-read");
            } else if (AccessControlList.REST_CANNED_PUBLIC_READ_WRITE.equals(acl)) {
                metadata.put("x-amz-acl", "public-read-write");
            } else if (AccessControlList.REST_CANNED_AUTHENTICATED_READ.equals(acl)) {
                metadata.put("x-amz-acl", "authenticated-read");
            } else {
                putNonStandardAcl = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating object bucketName=" + bucketName + ", objectKey=" + objectKey + "." + " Content-Type=" + metadata.get("Content-Type") + " Including data? " + (requestEntity != null) + " Metadata: " + metadata + " ACL: " + acl));
        }
        HttpMethodAndByteCount methodAndByteCount = this.performRestPut(bucketName, objectKey, metadata, null, requestEntity, true);
        HttpMethodBase httpMethod = methodAndByteCount.getHttpMethod();
        Map<String, String> map = new HashMap<String, String>();
        map.putAll(metadata);
        map.putAll(this.convertHeadersToMap(httpMethod.getResponseHeaders()));
        map.put("Content-Length", String.valueOf(methodAndByteCount.getByteCount()));
        map = ServiceUtils.cleanRestMetadataMap(map);
        if (putNonStandardAcl) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating object with a non-canned ACL using REST, so an extra ACL Put is required");
            }
            this.putAclImpl(bucketName, objectKey, acl);
        }
        return map;
    }

    protected Map copyObjectImpl(String sourceBucketName, String sourceObjectKey, String destinationBucketName, String destinationObjectKey, AccessControlList acl, Map destinationMetadata, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags) throws S3ServiceException {
        String tags;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Copying Object from " + sourceBucketName + ":" + sourceObjectKey + " to " + destinationBucketName + ":" + destinationObjectKey));
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("x-amz-copy-source", RestUtils.encodeUrlString(sourceBucketName + "/" + sourceObjectKey));
        if (destinationMetadata != null) {
            metadata.put("x-amz-metadata-directive", "REPLACE");
            metadata.putAll(destinationMetadata);
            if (!metadata.containsKey("Content-Type")) {
                metadata.put("Content-Type", "application/octet-stream");
            }
        } else {
            metadata.put("x-amz-metadata-directive", "COPY");
        }
        boolean putNonStandardAcl = false;
        if (acl != null) {
            if (AccessControlList.REST_CANNED_PRIVATE.equals(acl)) {
                metadata.put("x-amz-acl", "private");
            } else if (AccessControlList.REST_CANNED_PUBLIC_READ.equals(acl)) {
                metadata.put("x-amz-acl", "public-read");
            } else if (AccessControlList.REST_CANNED_PUBLIC_READ_WRITE.equals(acl)) {
                metadata.put("x-amz-acl", "public-read-write");
            } else if (AccessControlList.REST_CANNED_AUTHENTICATED_READ.equals(acl)) {
                metadata.put("x-amz-acl", "authenticated-read");
            } else {
                putNonStandardAcl = true;
            }
        }
        if (ifModifiedSince != null) {
            metadata.put("x-amz-copy-source-if-modified-since", ServiceUtils.formatRfc822Date(ifModifiedSince.getTime()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only copy object if-modified-since:" + ifModifiedSince));
            }
        }
        if (ifUnmodifiedSince != null) {
            metadata.put("x-amz-copy-source-if-unmodified-since", ServiceUtils.formatRfc822Date(ifUnmodifiedSince.getTime()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only copy object if-unmodified-since:" + ifUnmodifiedSince));
            }
        }
        if (ifMatchTags != null) {
            tags = ServiceUtils.join(ifMatchTags, ",");
            metadata.put("x-amz-copy-source-if-match", tags);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only copy object based on hash comparison if-match:" + tags));
            }
        }
        if (ifNoneMatchTags != null) {
            tags = ServiceUtils.join(ifNoneMatchTags, ",");
            metadata.put("x-amz-copy-source-if-none-match", tags);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only copy object based on hash comparison if-none-match:" + tags));
            }
        }
        HttpMethodAndByteCount methodAndByteCount = this.performRestPut(destinationBucketName, destinationObjectKey, metadata, null, null, false);
        XmlResponsesSaxParser.CopyObjectResultHandler handler = new XmlResponsesSaxParser(this.jets3tProperties).parseCopyObjectResponse(new HttpMethodReleaseInputStream((HttpMethod)methodAndByteCount.getHttpMethod()));
        methodAndByteCount.getHttpMethod().releaseConnection();
        if (handler.isErrorResponse()) {
            throw new S3ServiceException("Copy failed: Code=" + handler.getErrorCode() + ", Message=" + handler.getErrorMessage() + ", RequestId=" + handler.getErrorRequestId() + ", HostId=" + handler.getErrorHostId());
        }
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("Last-Modified", handler.getLastModified());
        map.put("ETag", handler.getETag());
        map.putAll(this.convertHeadersToMap(methodAndByteCount.getHttpMethod().getResponseHeaders()));
        map = ServiceUtils.cleanRestMetadataMap(map);
        if (putNonStandardAcl) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating object with a non-canned ACL using REST, so an extra ACL Put is required");
            }
            this.putAclImpl(destinationBucketName, destinationObjectKey, acl);
        }
        return map;
    }

    protected S3Object getObjectDetailsImpl(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags) throws S3ServiceException {
        return this.getObjectImpl(true, bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, null, null);
    }

    protected S3Object getObjectImpl(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd) throws S3ServiceException {
        return this.getObjectImpl(false, bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd);
    }

    private S3Object getObjectImpl(boolean headOnly, String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd) throws S3ServiceException {
        String tags;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving " + (headOnly ? "Head" : "All") + " information for bucket " + bucketName + " and object " + objectKey));
        }
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        if (ifModifiedSince != null) {
            requestHeaders.put("If-Modified-Since", ServiceUtils.formatRfc822Date(ifModifiedSince.getTime()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only retrieve object if-modified-since:" + ifModifiedSince));
            }
        }
        if (ifUnmodifiedSince != null) {
            requestHeaders.put("If-Unmodified-Since", ServiceUtils.formatRfc822Date(ifUnmodifiedSince.getTime()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only retrieve object if-unmodified-since:" + ifUnmodifiedSince));
            }
        }
        if (ifMatchTags != null) {
            tags = ServiceUtils.join(ifMatchTags, ",");
            requestHeaders.put("If-Match", tags);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only retrieve object based on hash comparison if-match:" + tags));
            }
        }
        if (ifNoneMatchTags != null) {
            tags = ServiceUtils.join(ifNoneMatchTags, ",");
            requestHeaders.put("If-None-Match", tags);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only retrieve object based on hash comparison if-none-match:" + tags));
            }
        }
        if (byteRangeStart != null || byteRangeEnd != null) {
            String range = "bytes=" + (byteRangeStart != null ? byteRangeStart.toString() : "") + "-" + (byteRangeEnd != null ? byteRangeEnd.toString() : "");
            requestHeaders.put("Range", range);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Only retrieve object if it is within range:" + range));
            }
        }
        HttpMethodBase httpMethod = null;
        httpMethod = headOnly ? this.performRestHead(bucketName, objectKey, null, requestHeaders) : this.performRestGet(bucketName, objectKey, null, requestHeaders);
        HashMap map = new HashMap();
        map.putAll(this.convertHeadersToMap(httpMethod.getResponseHeaders()));
        S3Object responseObject = new S3Object(objectKey);
        responseObject.setBucketName(bucketName);
        responseObject.replaceAllMetadata(ServiceUtils.cleanRestMetadataMap(map));
        responseObject.setMetadataComplete(true);
        if (!headOnly) {
            HttpMethodReleaseInputStream releaseIS = new HttpMethodReleaseInputStream((HttpMethod)httpMethod);
            responseObject.setDataInputStream(releaseIS);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Releasing HttpMethod after HEAD");
            }
            httpMethod.releaseConnection();
        }
        return responseObject;
    }

    protected String getBucketLocationImpl(String bucketName) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving location of Bucket: " + bucketName));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("location", "");
        HttpMethodBase httpMethod = this.performRestGet(bucketName, null, requestParameters, null);
        return new XmlResponsesSaxParser(this.jets3tProperties).parseBucketLocationResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod));
    }

    protected S3BucketLoggingStatus getBucketLoggingStatusImpl(String bucketName) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving Logging Status for Bucket: " + bucketName));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("logging", "");
        HttpMethodBase httpMethod = this.performRestGet(bucketName, null, requestParameters, null);
        return new XmlResponsesSaxParser(this.jets3tProperties).parseLoggingStatusResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)).getBucketLoggingStatus();
    }

    protected void setBucketLoggingStatusImpl(String bucketName, S3BucketLoggingStatus status) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting Logging Status for bucket: " + bucketName));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("logging", "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "text/plain");
        try {
            String statusAsXml = status.toXml();
            metadata.put("Content-Length", String.valueOf(statusAsXml.length()));
            this.performRestPut(bucketName, null, metadata, requestParameters, (RequestEntity)new StringRequestEntity(statusAsXml, "text/plain", Constants.DEFAULT_ENCODING), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to encode LoggingStatus XML document", e);
        }
    }

    protected boolean isRequesterPaysBucketImpl(String bucketName) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving Request Payment Configuration settings for Bucket: " + bucketName));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("requestPayment", "");
        HttpMethodBase httpMethod = this.performRestGet(bucketName, null, requestParameters, null);
        return new XmlResponsesSaxParser(this.jets3tProperties).parseRequestPaymentConfigurationResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod));
    }

    protected void setRequesterPaysBucketImpl(String bucketName, boolean requesterPays) throws S3ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting Request Payment Configuration settings for bucket: " + bucketName));
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("requestPayment", "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "text/plain");
        try {
            String xml = "<RequestPaymentConfiguration xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\"><Payer>" + (requesterPays ? "Requester" : "BucketOwner") + "</Payer>" + "</RequestPaymentConfiguration>";
            metadata.put("Content-Length", String.valueOf(xml.length()));
            this.performRestPut(bucketName, null, metadata, requestParameters, (RequestEntity)new StringRequestEntity(xml, "text/plain", Constants.DEFAULT_ENCODING), true);
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to encode RequestPaymentConfiguration XML document", e);
        }
    }

    public S3Object putObjectWithSignedUrl(String signedPutUrl, S3Object object) throws S3ServiceException {
        boolean isLiveMD5HashingRequired;
        PutMethod putMethod = new PutMethod(signedPutUrl);
        Map renamedMetadata = RestUtils.renameMetadataKeys(object.getMetadataMap());
        this.addMetadataToHeaders((HttpMethodBase)putMethod, renamedMetadata);
        if (!object.containsMetadata("Content-Length")) {
            throw new IllegalStateException("Content-Length must be specified for objects put using signed PUT URLs");
        }
        RepeatableRequestEntity repeatableRequestEntity = null;
        boolean bl = isLiveMD5HashingRequired = object.getMetadata("Content-MD5") == null;
        if (object.getDataInputStream() != null) {
            repeatableRequestEntity = new RepeatableRequestEntity(object.getKey(), object.getDataInputStream(), object.getContentType(), object.getContentLength(), this.jets3tProperties, isLiveMD5HashingRequired);
            putMethod.setRequestEntity((RequestEntity)repeatableRequestEntity);
        }
        this.performRequest((HttpMethodBase)putMethod, new int[]{200});
        putMethod.releaseConnection();
        if (repeatableRequestEntity != null && isLiveMD5HashingRequired) {
            String hexMD5OfUploadedData = ServiceUtils.toHex(repeatableRequestEntity.getMD5DigestOfData());
            if (!object.getETag().equals(hexMD5OfUploadedData)) {
                throw new S3ServiceException("Mismatch between MD5 hash of uploaded data (" + hexMD5OfUploadedData + ") and ETag returned by S3 (" + object.getETag() + ") for: " + object.getKey());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Object upload was automatically verified, the calculated MD5 hash value matched the ETag returned by S3: " + object.getKey()));
            }
        }
        try {
            block13: {
                S3Object uploadedObject = ServiceUtils.buildObjectFromUrl(putMethod.getURI().getHost(), putMethod.getPath());
                object.setBucketName(uploadedObject.getBucketName());
                object.setKey(uploadedObject.getKey());
                try {
                    object.setLastModifiedDate(ServiceUtils.parseRfc822Date(putMethod.getResponseHeader("Date").getValue()));
                }
                catch (ParseException e1) {
                    if (!log.isWarnEnabled()) break block13;
                    log.warn((Object)"Unable to interpret date of object PUT in S3", (Throwable)e1);
                }
            }
            try {
                object.closeDataInputStream();
            }
            catch (IOException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Unable to close data input stream for object '" + object.getKey() + "'"), (Throwable)e);
                }
            }
        }
        catch (URIException e) {
            throw new S3ServiceException("Unable to lookup URI for object created with signed PUT", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to determine name of object created with signed PUT", e);
        }
        return object;
    }

    public void deleteObjectWithSignedUrl(String signedDeleteUrl) throws S3ServiceException {
        DeleteMethod deleteMethod = new DeleteMethod(signedDeleteUrl);
        this.performRequest((HttpMethodBase)deleteMethod, new int[]{204, 200});
        deleteMethod.releaseConnection();
    }

    public S3Object getObjectWithSignedUrl(String signedGetUrl) throws S3ServiceException {
        return this.getObjectWithSignedUrlImpl(signedGetUrl, false);
    }

    public S3Object getObjectDetailsWithSignedUrl(String signedHeadUrl) throws S3ServiceException {
        return this.getObjectWithSignedUrlImpl(signedHeadUrl, true);
    }

    public AccessControlList getObjectAclWithSignedUrl(String signedAclUrl) throws S3ServiceException {
        GetMethod httpMethod = new GetMethod(signedAclUrl);
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("acl", "");
        this.performRequest((HttpMethodBase)httpMethod, new int[]{200});
        return new XmlResponsesSaxParser(this.jets3tProperties).parseAccessControlListResponse(new HttpMethodReleaseInputStream((HttpMethod)httpMethod)).getAccessControlList();
    }

    public void putObjectAclWithSignedUrl(String signedAclUrl, AccessControlList acl) throws S3ServiceException {
        PutMethod putMethod = new PutMethod(signedAclUrl);
        if (acl != null) {
            if (AccessControlList.REST_CANNED_PRIVATE.equals(acl)) {
                putMethod.addRequestHeader("x-amz-acl", "private");
            } else if (AccessControlList.REST_CANNED_PUBLIC_READ.equals(acl)) {
                putMethod.addRequestHeader("x-amz-acl", "public-read");
            } else if (AccessControlList.REST_CANNED_PUBLIC_READ_WRITE.equals(acl)) {
                putMethod.addRequestHeader("x-amz-acl", "public-read-write");
            } else if (AccessControlList.REST_CANNED_AUTHENTICATED_READ.equals(acl)) {
                putMethod.addRequestHeader("x-amz-acl", "authenticated-read");
            } else {
                try {
                    String aclAsXml = acl.toXml();
                    putMethod.setRequestEntity((RequestEntity)new StringRequestEntity(aclAsXml, "text/xml", Constants.DEFAULT_ENCODING));
                }
                catch (UnsupportedEncodingException e) {
                    throw new S3ServiceException("Unable to encode ACL XML document", e);
                }
            }
        }
        this.performRequest((HttpMethodBase)putMethod, new int[]{200});
        putMethod.releaseConnection();
    }

    private S3Object getObjectWithSignedUrlImpl(String signedGetOrHeadUrl, boolean headOnly) throws S3ServiceException {
        Object httpMethod = null;
        httpMethod = headOnly ? new HeadMethod(signedGetOrHeadUrl) : new GetMethod(signedGetOrHeadUrl);
        this.performRequest((HttpMethodBase)httpMethod, new int[]{200});
        HashMap map = new HashMap();
        map.putAll(this.convertHeadersToMap(httpMethod.getResponseHeaders()));
        S3Object responseObject = null;
        try {
            responseObject = ServiceUtils.buildObjectFromUrl(httpMethod.getURI().getHost(), httpMethod.getPath().substring(1));
        }
        catch (URIException e) {
            throw new S3ServiceException("Unable to lookup URI for object created with signed PUT", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new S3ServiceException("Unable to determine name of object created with signed PUT", e);
        }
        responseObject.replaceAllMetadata(ServiceUtils.cleanRestMetadataMap(map));
        responseObject.setMetadataComplete(true);
        if (!headOnly) {
            HttpMethodReleaseInputStream releaseIS = new HttpMethodReleaseInputStream((HttpMethod)httpMethod);
            responseObject.setDataInputStream(releaseIS);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Releasing HttpMethod after HEAD");
            }
            httpMethod.releaseConnection();
        }
        return responseObject;
    }

    private class HttpMethodAndByteCount {
        private HttpMethodBase httpMethod = null;
        private long byteCount = 0L;

        public HttpMethodAndByteCount(HttpMethodBase httpMethod, long byteCount) {
            this.httpMethod = httpMethod;
            this.byteCount = byteCount;
        }

        public HttpMethodBase getHttpMethod() {
            return this.httpMethod;
        }

        public long getByteCount() {
            return this.byteCount;
        }
    }
}

