/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.condition.bool.Expression;
import adams.flow.control.SubProcess;

public class ConditionalSubProcess
extends SubProcess {
    private static final long serialVersionUID = 619693652039880564L;
    protected AbstractBooleanCondition m_Condition;
    protected boolean m_DropTokensOnConditionFail;

    @Override
    public String globalInfo() {
        return "Encapsulates a sequence of flow items. The first actor must accept input and the last one must produce output. But the sequence gets only executed if the condition holds true.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("condition", "condition", new Expression());
        this.m_OptionManager.add("drop-tokens-on-condition-fail", "dropTokensOnConditionFail", false);
    }

    public void setCondition(AbstractBooleanCondition value) {
        this.m_Condition = value;
        this.reset();
    }

    public AbstractBooleanCondition getCondition() {
        return this.m_Condition;
    }

    public String conditionTipText() {
        return "The condition to evaluate - only as long as it evaluates to 'true' the loop actors get executed.";
    }

    public void setDropTokensOnConditionFail(boolean value) {
        this.m_DropTokensOnConditionFail = value;
        this.reset();
    }

    public boolean getDropTokensOnConditionFail() {
        return this.m_DropTokensOnConditionFail;
    }

    public String dropTokensOnConditionFailTipText() {
        return "If enabled, any incoming tokens that weren't processed due to the condition evaluating to false will get dropped and not forwarded.";
    }

    @Override
    public String getQuickInfo() {
        return this.m_Condition.getQuickInfo();
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && this.m_Condition == null) {
            result = "No condition provided!";
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (this.m_Condition.evaluate(this, this.m_CurrentToken)) {
            result = super.doExecute();
        } else if (!this.m_DropTokensOnConditionFail) {
            this.getOutputTokens().add(this.m_CurrentToken);
        }
        return result;
    }
}

