/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.ConsoleObject;
import adams.flow.control.AbstractDirectedControlActor;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractExternalActor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.GlobalActorReference;
import adams.flow.standalone.GlobalActors;
import java.util.Vector;

public class GlobalActorHelper
extends ConsoleObject {
    private static final long serialVersionUID = -763479272812116920L;

    public AbstractActor findGlobalActor(ActorHandler group, GlobalActorReference name) {
        AbstractActor result = null;
        for (int i = 0; i < group.size(); ++i) {
            AbstractExternalActor external;
            if (group.get(i) instanceof GlobalActors) {
                GlobalActors global = (GlobalActors)group.get(i);
                int index = global.indexOf(name.toString());
                if (index <= -1) continue;
                result = global.get(index);
                break;
            }
            if (group.get(i) instanceof AbstractExternalActor && (external = (AbstractExternalActor)group.get(i)).getExternalActor() instanceof ActorHandler && (result = this.findGlobalActor((ActorHandler)((Object)external.getExternalActor()), name)) != null) break;
        }
        return result;
    }

    public AbstractActor findGlobalActor(AbstractActor root, GlobalActorReference name) {
        AbstractActor result = null;
        if (root == null) {
            this.getSystemErr().println("No root container found!");
        } else if (!(root instanceof AbstractDirectedControlActor)) {
            this.getSystemErr().println("Root is not a container ('" + root.getFullName() + "'/" + root.getClass().getName() + ")!");
            root = null;
        }
        if (root != null) {
            result = this.findGlobalActor((ActorHandler)((Object)root), name);
        }
        return result;
    }

    public AbstractActor findGlobalActorRecursive(AbstractActor actor, GlobalActorReference name) {
        AbstractActor result = null;
        Vector<ActorHandler> handlers = ActorUtils.findActorHandlers(actor, true);
        for (int i = 0; i < handlers.size() && (result = this.findGlobalActor(handlers.get(i), name)) == null; ++i) {
        }
        return result;
    }
}

