/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractGlobalActor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorUtils;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.MutableActorHandler;
import adams.flow.processor.AbstractModifyingProcessor;
import adams.flow.standalone.GlobalActors;
import java.util.HashSet;

public class RemoveUnusedGlobalActors
extends AbstractModifyingProcessor {
    private static final long serialVersionUID = 1634101991639994065L;
    protected GlobalActorHelper m_Helper;

    @Override
    public String globalInfo() {
        return "Removes all unused global actors. Disabled actors referencing global actors are treated as if they were enabled. If a GlobalActors actor ends up being empty, it will get removed as well.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Helper = new GlobalActorHelper();
    }

    protected void locateGlobalActors(AbstractActor actor, HashSet<String> fullNames) {
        block4: {
            if (!(actor instanceof ActorHandler)) break block4;
            ActorHandler handler = (ActorHandler)((Object)actor);
            if (handler instanceof GlobalActors) {
                for (int i = 0; i < handler.size(); ++i) {
                    fullNames.add(handler.get(i).getFullName());
                }
            } else {
                for (int i = 0; i < handler.size(); ++i) {
                    this.locateGlobalActors(handler.get(i), fullNames);
                }
            }
        }
    }

    protected void locateGlobalActorReferences(AbstractActor actor, HashSet<String> fullNames) {
        if (actor instanceof AbstractGlobalActor) {
            AbstractGlobalActor reference = (AbstractGlobalActor)actor;
            AbstractActor global = this.m_Helper.findGlobalActorRecursive(reference, reference.getGlobalName());
            if (global != null) {
                fullNames.add(global.getFullName());
            }
        } else if (actor instanceof ActorHandler) {
            ActorHandler handler = (ActorHandler)((Object)actor);
            for (int i = 0; i < handler.size(); ++i) {
                this.locateGlobalActorReferences(handler.get(i), fullNames);
            }
        }
    }

    protected void removeUnused(AbstractActor actor, HashSet<String> unused) {
        this.m_ModifiedActor = actor.shallowCopy();
        this.m_Modified = true;
        HashSet<GlobalActors> parents = new HashSet<GlobalActors>();
        for (String fullname : unused) {
            AbstractActor global = ActorUtils.locate(fullname, actor);
            if (global == null) {
                this.getSystemErr().println("Failed to locate global actor: " + fullname);
                continue;
            }
            GlobalActors globalActors = (GlobalActors)global.getParent();
            globalActors.remove(global.index());
            parents.add(globalActors);
        }
        for (GlobalActors gactors : parents) {
            if (gactors.size() != 0) continue;
            if (this.isDebugOn()) {
                this.debug("Removing empty GlobalActors: " + gactors.getFullName());
            }
            ((MutableActorHandler)((Object)gactors.getParent())).remove(gactors.index());
        }
    }

    @Override
    protected void processActor(AbstractActor actor) {
        HashSet<String> global = new HashSet<String>();
        this.locateGlobalActors(actor, global);
        if (this.isDebugOn()) {
            this.debug("global actors found: " + global);
        }
        HashSet<String> referenced = new HashSet<String>();
        this.locateGlobalActorReferences(actor, referenced);
        if (this.isDebugOn()) {
            this.debug("references found: " + referenced);
        }
        HashSet unused = (HashSet)global.clone();
        unused.removeAll(referenced);
        if (this.isDebugOn()) {
            this.debug("unused global actors: " + unused);
        }
        if (unused.size() > 0) {
            this.removeUnused(actor, unused);
        }
    }
}

