/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;

public class SingleFileSupplier
extends AbstractSource {
    private static final long serialVersionUID = -1506790344830159240L;
    protected PlaceholderFile m_File;
    protected Token m_OutputToken;

    @Override
    public String globalInfo() {
        return "Supplies a single file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("file", "file", new PlaceholderFile("."));
    }

    @Override
    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("file");
        if (variable != null) {
            return variable;
        }
        if (this.m_File != null) {
            return this.m_File.toString();
        }
        return null;
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    public void setFile(PlaceholderFile value) {
        this.m_File = value;
    }

    public PlaceholderFile getFile() {
        return this.m_File;
    }

    public String fileTipText() {
        return "The file to supply.";
    }

    @Override
    protected String doExecute() {
        this.m_OutputToken = new Token(this.m_File.getAbsolutePath());
        return null;
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }

    @Override
    public void wrapUp() {
        super.wrapUp();
        this.m_OutputToken = null;
    }
}

