/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.CloneHandler;
import adams.core.ConsoleObject;
import adams.core.Properties;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.gui.core.GUIHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class Favorites
implements Comparable,
CloneHandler<Favorites> {
    public static final String FILENAME = "GenericObjectEditorFavorites.props";
    public static final String SEPARATOR = "-";
    public static final String TEMPORARY = "$TMP$";
    protected Properties m_Properties;
    protected boolean m_Modified;
    protected boolean m_AutoSave;
    protected static Favorites m_Singleton;

    public Favorites() {
        this(true);
    }

    public Favorites(boolean autosave) {
        this.m_AutoSave = autosave;
        this.m_Modified = false;
    }

    public void setAutoSave(boolean value) {
        this.m_AutoSave = value;
    }

    public boolean isAutoSave() {
        return this.m_AutoSave;
    }

    public void setModified(boolean value) {
        this.m_Modified = value;
    }

    public boolean isModified() {
        return this.m_Modified;
    }

    public void setProperties(Properties value) {
        this.m_Properties = (Properties)value.clone();
    }

    public synchronized Properties getProperties() {
        if (this.m_Properties == null) {
            this.load();
            if (this.removeTemporaryFavorites() && this.m_AutoSave) {
                this.updateFavorites();
            }
        }
        return this.m_Properties;
    }

    protected synchronized void load() {
        this.m_Properties = new Properties();
        File file = new File(Environment.getInstance().getHome() + File.separator + FILENAME);
        if (file.exists()) {
            this.m_Properties.load(file.getAbsolutePath());
        }
    }

    public void clear() {
        this.getProperties().clear();
        this.m_Modified = true;
        if (this.m_AutoSave) {
            this.updateFavorites();
        }
    }

    public Vector<Favorite> getFavorites(String classname) {
        try {
            return this.getFavorites(Class.forName(classname));
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Vector<Favorite>();
        }
    }

    public Vector<Favorite> getFavorites(Class cls) {
        Vector<Favorite> result = new Vector<Favorite>();
        String prefix = cls.getName() + SEPARATOR;
        Enumeration<?> enm = this.getProperties().propertyNames();
        while (enm.hasMoreElements()) {
            String key = (String)enm.nextElement();
            if (!key.startsWith(prefix)) continue;
            Favorite favorite = new Favorite(key.substring(prefix.length()), this.getProperties().getProperty(key));
            result.add(favorite);
        }
        Collections.sort(result);
        return result;
    }

    public Vector<String> getSuperclasses() {
        HashSet<String> set = new HashSet<String>();
        Enumeration<?> enm = this.getProperties().propertyNames();
        while (enm.hasMoreElements()) {
            String key = (String)enm.nextElement();
            String classname = key.substring(0, key.indexOf(SEPARATOR));
            set.add(classname);
        }
        Vector<String> result = new Vector<String>(set);
        Collections.sort(result);
        return result;
    }

    public Favorite getFavorite(Class cls, String name) {
        String key = cls.getName() + SEPARATOR + name;
        if (this.getProperties().hasKey(key)) {
            return new Favorite(name, this.getProperties().getProperty(key));
        }
        return null;
    }

    public void addFavorite(Class cls, Object obj, String name) {
        this.getProperties().setProperty(cls.getName() + SEPARATOR + name, OptionUtils.getCommandLine(obj));
        this.m_Modified = true;
        if (this.m_AutoSave) {
            this.updateFavorites();
        }
    }

    public void removeFavorites(String classname) {
        try {
            this.removeFavorites(Class.forName(classname));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeFavorites(Class cls) {
        Vector<Favorite> favorites = this.getFavorites(cls);
        for (int i = 0; i < favorites.size(); ++i) {
            this.getProperties().removeKey(cls.getName() + SEPARATOR + favorites.get(i).getName());
        }
        this.m_Modified = true;
        if (this.m_AutoSave) {
            this.updateFavorites();
        }
    }

    public void removeFavorite(String classname, String name) {
        try {
            this.removeFavorite(Class.forName(classname), name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeFavorite(Class cls, String name) {
        this.getProperties().removeKey(cls.getName() + SEPARATOR + name);
        this.m_Modified = true;
        if (this.m_AutoSave) {
            this.updateFavorites();
        }
    }

    public String getFilename() {
        return Environment.getInstance().getHome() + File.separator + FILENAME;
    }

    public synchronized boolean updateFavorites() {
        boolean result;
        String filename = this.getFilename();
        if (!this.m_Properties.save(filename)) {
            result = false;
            System.err.println("Error saving GOE favorites to '" + filename + "'!");
        } else {
            result = true;
            this.m_Modified = false;
        }
        return result;
    }

    public void customizePopupMenu(JPopupMenu menu, Class cls, Object current, FavoriteSelectionListener listener) {
        Vector<Favorite> favorites = this.getFavorites(cls);
        JMenu submenu = new JMenu("Favorites");
        submenu.setIcon(GUIHelper.getIcon("favorite.gif"));
        menu.add(submenu);
        final Class fCls = cls;
        final Object fCurrent = current;
        JMenuItem item = new JMenuItem("Add to favorites...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = null;
                do {
                    if ((name = JOptionPane.showInputDialog("Please enter name for favorite:")) == null) {
                        return;
                    }
                    if (!(name = name.trim()).startsWith("$")) continue;
                    GUIHelper.showErrorMessage(null, "Name cannot start with '$'!");
                    name = null;
                } while (name == null);
                Favorites.this.addFavorite(fCls, fCurrent, name);
            }
        });
        submenu.add(item);
        item = new JMenuItem("Add as temporary favorite");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Favorites.this.addFavorite(fCls, fCurrent, Favorites.TEMPORARY);
            }
        });
        submenu.add(item);
        final FavoriteSelectionListener fListener = listener;
        for (int i = 0; i < favorites.size(); ++i) {
            Favorite favorite;
            String name;
            if (i == 0) {
                submenu.addSeparator();
            }
            if ((name = (favorite = favorites.get(i)).getName()).equals(TEMPORARY)) {
                name = "-Temp-";
            }
            item = new JMenuItem(name);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    fListener.favoriteSelected(new FavoriteSelectionEvent(fListener, favorite));
                }
            });
            submenu.add(item);
        }
    }

    @Override
    public Favorites getClone() {
        Favorites result = new Favorites(this.m_AutoSave);
        result.m_Modified = this.m_Modified;
        result.m_Properties = this.m_Properties.getClone();
        return result;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        Favorites f = (Favorites)o;
        int result = this.m_Properties.compareTo(f.m_Properties);
        return result;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    protected boolean removeTemporaryFavorites() {
        boolean result = false;
        Vector<String> tmp = new Vector<String>();
        Enumeration<?> enm = this.m_Properties.propertyNames();
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            if (!name.endsWith("-$TMP$")) continue;
            tmp.add(name);
        }
        if (tmp.size() > 0) {
            result = true;
            for (int i = 0; i < tmp.size(); ++i) {
                this.m_Properties.removeKey((String)tmp.get(i));
            }
        }
        return result;
    }

    public static synchronized Favorites getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new Favorites();
            m_Singleton.getProperties();
        }
        return m_Singleton;
    }

    public static synchronized void reload() {
        Favorites.getSingleton().load();
    }

    public static interface FavoriteSelectionListener {
        public void favoriteSelected(FavoriteSelectionEvent var1);
    }

    public static class FavoriteSelectionEvent
    extends EventObject {
        private static final long serialVersionUID = -3355442271698515292L;
        protected Favorite m_Favorite;

        public FavoriteSelectionEvent(Object source, Favorite favorite) {
            super(source);
            this.m_Favorite = favorite;
        }

        public Favorite getFavorite() {
            return this.m_Favorite;
        }
    }

    public static class Favorite
    extends ConsoleObject
    implements Comparable,
    CloneHandler<Favorite> {
        private static final long serialVersionUID = 9155308607371430795L;
        protected String m_Name;
        protected String m_Commandline;

        public Favorite(String name, String cmd) {
            this.m_Name = name;
            this.m_Commandline = cmd;
        }

        public String getName() {
            return this.m_Name;
        }

        public String getCommandline() {
            return this.m_Commandline;
        }

        public Object getObject() {
            Object result;
            try {
                result = OptionUtils.forAnyCommandLine(Object.class, this.m_Commandline);
            }
            catch (Exception e) {
                this.getSystemErr().printStackTrace(e);
                result = null;
            }
            return result;
        }

        @Override
        public Favorite getClone() {
            return new Favorite(this.m_Name, this.m_Commandline);
        }

        public int compareTo(Object o) {
            if (o == null) {
                return 1;
            }
            if (!(o instanceof Favorite)) {
                return -1;
            }
            Favorite f = (Favorite)o;
            int result = this.getName().toLowerCase().compareTo(f.getName().toLowerCase());
            if (result == 0) {
                result = this.getCommandline().compareTo(f.getCommandline());
            }
            return result;
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public String toString() {
            return this.m_Name;
        }
    }
}

