/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.print;

import adams.core.io.PlaceholderFile;
import adams.gui.core.MouseUtils;
import adams.gui.print.JComponentWriter;
import adams.gui.print.JComponentWriterFileChooser;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JComponent;

public class PrintMouseListener
extends MouseAdapter {
    protected JComponent m_Component;
    protected static JComponentWriterFileChooser m_FileChooser;

    public PrintMouseListener(JComponent component) {
        this(component, component);
    }

    public PrintMouseListener(JComponent listener, JComponent printed) {
        this.initFileChooser();
        this.m_Component = printed;
        listener.addMouseListener(this);
    }

    protected synchronized void initFileChooser() {
        if (m_FileChooser != null) {
            return;
        }
        m_FileChooser = new JComponentWriterFileChooser();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (MouseUtils.isPrintScreenClick(e)) {
            e.consume();
            this.saveComponent();
        }
    }

    public void saveComponent() {
        int result = m_FileChooser.showSaveDialog(this.m_Component);
        if (result != 0) {
            return;
        }
        try {
            File file = m_FileChooser.getSelectedFile().getAbsoluteFile();
            JComponentWriter writer = m_FileChooser.getWriter();
            writer.setComponent(this.m_Component);
            writer.setFile(new PlaceholderFile(file));
            writer.toOutput();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

