/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objecttree;

import adams.core.Utils;
import adams.gui.core.BaseTreeNode;

public class Node
extends BaseTreeNode {
    private static final long serialVersionUID = 39921763469189066L;
    protected String m_Property;
    protected boolean m_ArrayElement;

    public Node(String property, Object obj) {
        this(property, obj, false);
    }

    public Node(String property, Object obj, boolean element) {
        super(obj);
        this.m_Property = property;
        this.m_ArrayElement = element;
    }

    public boolean isArrayElement() {
        return this.m_ArrayElement;
    }

    public boolean isArray() {
        return this.getUserObject().getClass().isArray();
    }

    public String toRepresentation() {
        if (this.isArray()) {
            return Utils.arrayToString(this.getUserObject());
        }
        return this.getUserObject().toString();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("<html>");
        if (this.m_Property == null) {
            result.append("this");
        } else {
            result.append(this.m_Property);
        }
        result.append(" <font color=\"gray\">[");
        String levels = "";
        Class<?> cls = this.getUserObject().getClass();
        while (cls.isArray()) {
            levels = levels + "[]";
            cls = cls.getComponentType();
        }
        result.append(cls.getName());
        result.append(levels);
        result.append("]</font>");
        result.append("</html>");
        return result.toString();
    }
}

