/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.transformer;

import adams.core.annotation.MixedCopyright;
import adams.data.jai.transformer.AbstractJAITransformer;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Kernel;

@MixedCopyright(copyright="Jerry Huxtable", author="Jerry Huxtable", url="http://www.jhlabs.com/ip/blurring.html")
public class GaussianBlur
extends AbstractJAITransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected double m_Radius;

    public String globalInfo() {
        return "Performs a gaussian blur.\nOriginal code taken from here:\nhttp://www.jhlabs.com/ip/blurring.html";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("radius", "radius", (Object)2.0, (Number)1.0E-4, null);
    }

    public void setRadius(double value) {
        if (value > 0.0) {
            this.m_Radius = value;
            this.reset();
        } else {
            this.getSystemErr().println("Radius has to be >0, provided: " + value);
        }
    }

    public double getRadius() {
        return this.m_Radius;
    }

    public String radiusTipText() {
        return "The blur radius.";
    }

    protected int clamp(int c) {
        if (c < 0) {
            return 0;
        }
        if (c > 255) {
            return 255;
        }
        return c;
    }

    protected void convolveAndTranspose(Kernel kernel, int[] inPixels, int[] outPixels, int width, int height) {
        float[] matrix = kernel.getKernelData(null);
        int cols = kernel.getWidth();
        int cols2 = cols / 2;
        for (int y = 0; y < height; ++y) {
            int index = y;
            int ioffset = y * width;
            for (int x = 0; x < width; ++x) {
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                float a = 0.0f;
                int moffset = cols2;
                for (int col = -cols2; col <= cols2; ++col) {
                    float f = matrix[moffset + col];
                    if (f == 0.0f) continue;
                    int ix = x + col;
                    if (ix < 0) {
                        ix = 0;
                    } else if (ix >= width) {
                        ix = width - 1;
                    }
                    int rgb = inPixels[ioffset + ix];
                    a += f * (float)(rgb >> 24 & 0xFF);
                    r += f * (float)(rgb >> 16 & 0xFF);
                    g += f * (float)(rgb >> 8 & 0xFF);
                    b += f * (float)(rgb & 0xFF);
                }
                int ia = 255;
                int ir = this.clamp((int)((double)r + 0.5));
                int ig = this.clamp((int)((double)g + 0.5));
                int ib = this.clamp((int)((double)b + 0.5));
                outPixels[index] = ia << 24 | ir << 16 | ig << 8 | ib;
                index += height;
            }
        }
    }

    protected Kernel makeKernel(float radius) {
        int r = (int)Math.ceil(radius);
        int rows = r * 2 + 1;
        float[] matrix = new float[rows];
        float sigma = radius / 3.0f;
        float sigma22 = 2.0f * sigma * sigma;
        float sigmaPi2 = (float)(Math.PI * 2 * (double)sigma);
        float sqrtSigmaPi2 = (float)Math.sqrt(sigmaPi2);
        float radius2 = radius * radius;
        float total = 0.0f;
        int index = 0;
        for (int row = -r; row <= r; ++row) {
            float distance = row * row;
            matrix[index] = distance > radius2 ? 0.0f : (float)Math.exp(-distance / sigma22) / sqrtSigmaPi2;
            total += matrix[index];
            ++index;
        }
        int i = 0;
        while (i < rows) {
            int n = i++;
            matrix[n] = matrix[n] / total;
        }
        return new Kernel(rows, 1, matrix);
    }

    @Override
    protected BufferedImage[] doTransform(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        ColorModel dstCM = img.getColorModel();
        BufferedImage[] result = new BufferedImage[]{new BufferedImage(dstCM, dstCM.createCompatibleWritableRaster(img.getWidth(), img.getHeight()), dstCM.isAlphaPremultiplied(), null)};
        Kernel kernel = this.makeKernel((float)this.m_Radius);
        int[] inPixels = new int[width * height];
        int[] outPixels = new int[width * height];
        img.getRGB(0, 0, width, height, inPixels, 0, width);
        this.convolveAndTranspose(kernel, inPixels, outPixels, width, height);
        this.convolveAndTranspose(kernel, outPixels, inPixels, height, width);
        result[0].setRGB(0, 0, width, height, inPixels, 0, width);
        return result;
    }
}

