/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import de.intarsys.pdf.pd.PDCSSeparation;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtCSSpecial;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;

public class AwtCSSeparation
extends AwtCSSpecial {
    public AwtCSSeparation(PDColorSpace pdColorSpace) {
        super(pdColorSpace);
    }

    protected ColorSpace createColorSpace() {
        return new SeparationColorSpace();
    }

    public ColorModel getColorModel(PDImage pdImage) {
        return new ComponentColorModel(this.getColorSpace(), false, false, 1, 0);
    }

    public int getNumComponents() {
        return 1;
    }

    protected PDCSSeparation myPDColorSpace() {
        return (PDCSSeparation)this.getPDColorSpace();
    }

    class SeparationColorSpace
    extends ColorSpace {
        private ColorSpace alternateColorSpace;

        SeparationColorSpace() {
            super(6, 1);
            this.alternateColorSpace = AwtCSSeparation.getColorSpace(AwtCSSeparation.this.myPDColorSpace().getAlternate()).getColorSpace();
        }

        public float[] fromCIEXYZ(float[] colorvalue) {
            throw new UnsupportedOperationException();
        }

        public float[] fromRGB(float[] rgbvalue) {
            throw new UnsupportedOperationException();
        }

        public float[] toCIEXYZ(float[] colorvalue) {
            return this.alternateColorSpace.toCIEXYZ(AwtCSSeparation.this.myPDColorSpace().getTintTransform().evaluate(colorvalue));
        }

        public float[] toRGB(float[] colorvalue) {
            return this.alternateColorSpace.toRGB(AwtCSSeparation.this.myPDColorSpace().getTintTransform().evaluate(colorvalue));
        }
    }
}

