/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.flattener;

import adams.core.BufferedImageHelper;
import adams.data.jai.flattener.AbstractJAIFlattener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class Pixels
extends AbstractJAIFlattener {
    private static final long serialVersionUID = -8349656592325229512L;

    public String globalInfo() {
        return "Gets all the pixels of the image.";
    }

    @Override
    protected Instances createHeader(BufferedImage img) {
        int numPixels = img.getWidth() * img.getHeight();
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (int i = 0; i < numPixels; ++i) {
            atts.add(new Attribute("att_" + (i + 1)));
        }
        Instances result = new Instances(this.getClass().getName(), atts, 0);
        return result;
    }

    @Override
    protected Instance doFlatten(BufferedImage img) {
        DenseInstance result = null;
        int[] pixels = BufferedImageHelper.getPixels(img);
        double[] values = new double[this.m_Header.numAttributes()];
        for (int i = 0; i < pixels.length; ++i) {
            values[i] = pixels[i];
        }
        result = new DenseInstance(1.0, values);
        result.setDataset(this.m_Header);
        return result;
    }
}

