/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence.core;

import java.io.Serializable;
import java.util.List;
import java.util.Random;
import weka.classifiers.sequence.core.Distribution;
import weka.classifiers.sequence.core.EmissionState;
import weka.classifiers.sequence.core.ForwardAlgorithm;
import weka.classifiers.sequence.core.IllegalSymbolException;
import weka.classifiers.sequence.core.InvalidStructureException;
import weka.classifiers.sequence.core.InvalidViterbiPathException;
import weka.classifiers.sequence.core.ProfileHMM;
import weka.classifiers.sequence.core.State;
import weka.classifiers.sequence.core.Transition;
import weka.core.Utils;

public class SequenceGenerator
implements Serializable {
    private static final long serialVersionUID = -2685704498277103647L;
    private ProfileHMM hmm;
    private Random seedGenerator;

    public SequenceGenerator(ProfileHMM hmm, int seed) {
        this.hmm = hmm;
        this.seedGenerator = new Random(seed);
    }

    public String generateSequence() {
        String sequence = "";
        State currentState = this.hmm.getMatchState(0);
        while (!currentState.equals(this.hmm.getEndState())) {
            if (currentState instanceof EmissionState) {
                Distribution dist = currentState.getDistribution();
                sequence = sequence + dist.getSymbol(this.seedGenerator.nextInt());
            }
            currentState = this.calculateNextState(currentState);
        }
        return sequence;
    }

    public String generateLowerScoringSequence(double upperBoundOfScore) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException {
        String sequence;
        double actualScore;
        do {
            sequence = this.generateSequence();
            ForwardAlgorithm fwd = new ForwardAlgorithm(this.hmm, sequence);
            fwd.calculateForward();
            actualScore = fwd.getScore();
            System.out.println(actualScore);
        } while (actualScore >= upperBoundOfScore);
        return sequence;
    }

    private State calculateNextState(State currentState) {
        int index;
        Random rand = new Random(this.seedGenerator.nextInt());
        double actualProb = rand.nextDouble();
        double sum = 0.0;
        List<Transition> transitions = currentState.getAllOutgoing();
        if (this.hmm.isUseLogSpace()) {
            double[] realprobs = new double[transitions.size()];
            for (int i = 0; i < realprobs.length; ++i) {
                realprobs[i] = transitions.get(i).getProbability() == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(transitions.get(i).getProbability());
            }
            Utils.normalize((double[])realprobs);
            while (index < realprobs.length) {
                if ((sum += realprobs[index]) > actualProb) {
                    return transitions.get(index).getEnd();
                }
                ++index;
            }
        } else {
            for (index = 0; index < transitions.size(); ++index) {
                if (!((sum += transitions.get(index).getProbability()) > actualProb)) continue;
                return transitions.get(index).getEnd();
            }
        }
        return transitions.get(index).getEnd();
    }

    public ProfileHMM getHmm() {
        return this.hmm;
    }

    public void setHmm(ProfileHMM hmm) {
        this.hmm = hmm;
    }
}

