/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.Range;
import adams.core.io.SpreadSheet;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.Collections;
import java.util.Vector;

public class SpreadSheetPlotGenerator
extends AbstractTransformer {
    private static final long serialVersionUID = 1147935218531182101L;
    public static final String MISSING_CELL_VALUE = "MISSING";
    protected Range m_PlotColumns;
    protected Index m_SortColumn;
    protected boolean m_SortDescending;
    protected Index m_XColumn;
    protected double m_DefaultCellValue;
    protected Vector<SequencePlotterContainer> m_Containers;

    public String globalInfo() {
        return "Outputs plot containers generated from a spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "plotColumns", (Object)"");
        this.m_OptionManager.add("sort-column", "sortColumn", (Object)"");
        this.m_OptionManager.add("sort-descending", "sortDescending", (Object)false);
        this.m_OptionManager.add("x-column", "XColumn", (Object)"");
        this.m_OptionManager.add("default-cell-value", "defaultCellValue", (Object)-1.0);
    }

    protected void initialize() {
        super.initialize();
        this.m_Containers = new Vector();
        this.m_PlotColumns = new Range();
        this.m_SortColumn = new Index();
        this.m_XColumn = new Index();
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("plotColumns");
        if (variable != null) {
            return variable;
        }
        if (this.m_PlotColumns.getRange().length() > 0) {
            return this.m_PlotColumns.getRange();
        }
        return null;
    }

    public void setPlotColumns(String value) {
        this.m_PlotColumns.setRange(value);
        this.reset();
    }

    public String getPlotColumns() {
        return this.m_PlotColumns.getRange();
    }

    public String plotColumnsTipText() {
        return "The range of columns to include in the plot; " + this.m_PlotColumns.getExample();
    }

    public void setSortColumn(String value) {
        this.m_SortColumn.setIndex(value);
        this.reset();
    }

    public String getSortColumn() {
        return this.m_SortColumn.getIndex();
    }

    public String sortColumnTipText() {
        return "The (optional) index of the column to use for sorting; " + this.m_SortColumn.getExample();
    }

    public void setSortDescending(boolean value) {
        this.m_SortDescending = value;
        this.reset();
    }

    public boolean getSortDescending() {
        return this.m_SortDescending;
    }

    public String sortDescendingTipText() {
        return "If set to true, sorting is done in descending manner instead (ignored is using a column for X values).";
    }

    public void setXColumn(String value) {
        this.m_XColumn.setIndex(value);
        this.reset();
    }

    public String getXColumn() {
        return this.m_XColumn.getIndex();
    }

    public String XColumnTipText() {
        return "The (optional) index of the column which values to use as X values in the plot; " + this.m_XColumn.getExample();
    }

    public void setDefaultCellValue(double value) {
        this.m_DefaultCellValue = value;
        this.reset();
    }

    public double getDefaultCellValue() {
        return this.m_DefaultCellValue;
    }

    public String defaultCellValueTipText() {
        return "The default value for missing or non-numeric cells.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected String getCellString(SpreadSheet.Row row, int index) {
        String result = MISSING_CELL_VALUE;
        SpreadSheet.Cell cell = row.getCell(index);
        if (cell != null && !cell.isMissing()) {
            result = cell.getContent();
        }
        return result;
    }

    protected double getCellValue(SpreadSheet.Row row, int index) {
        double result = this.m_DefaultCellValue;
        SpreadSheet.Cell cell = row.getCell(index);
        if (cell != null && !cell.isMissing() && cell.isNumeric()) {
            result = Double.parseDouble(cell.getContent());
        }
        return result;
    }

    protected String doExecute() {
        SpreadSheet.Row row;
        int i;
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_PlotColumns.setMax(sheet.getColumnCount());
        this.m_SortColumn.setMax(sheet.getColumnCount());
        this.m_XColumn.setMax(sheet.getColumnCount());
        int xIndex = this.m_XColumn.getIntIndex();
        if (xIndex != -1 && !sheet.isNumeric(xIndex)) {
            xIndex = -1;
        }
        int sortIndex = this.m_SortColumn.getIntIndex();
        boolean sortNumeric = false;
        if (sortIndex != -1) {
            sortNumeric = sheet.isNumeric(sortIndex);
        }
        Vector<SortableRow> srows = new Vector<SortableRow>();
        for (i = 0; i < sheet.getRowCount(); ++i) {
            row = sheet.getRow(i);
            SortableRow srow = xIndex != -1 ? new SortableRow(new Double(this.getCellValue(row, xIndex)), row, false) : (sortIndex == -1 ? new SortableRow(new Integer(i), row, this.m_SortDescending) : (sortNumeric ? new SortableRow(new Double(this.getCellValue(row, sortIndex)), row, this.m_SortDescending) : new SortableRow((Comparable)((Object)this.getCellString(row, sortIndex)), row, this.m_SortDescending)));
            srows.add(srow);
        }
        Collections.sort(srows);
        this.m_Containers.clear();
        int[] plotCols = this.m_PlotColumns.getIntIndices();
        String[] plotNames = new String[plotCols.length];
        for (i = 0; i < plotNames.length; ++i) {
            plotNames[i] = sheet.getHeaderRow().getCell(plotCols[i]).getContent();
        }
        for (i = 0; i < srows.size(); ++i) {
            row = ((SortableRow)srows.get(i)).getRow();
            for (int n = 0; n < plotCols.length; ++n) {
                SequencePlotterContainer cont = xIndex == -1 ? new SequencePlotterContainer(plotNames[n], new Double(i), Double.valueOf(this.getCellValue(row, plotCols[n]))) : new SequencePlotterContainer(plotNames[n], Double.valueOf(this.getCellValue(row, xIndex)), Double.valueOf(this.getCellValue(row, plotCols[n])));
                this.m_Containers.add(cont);
            }
        }
        return result;
    }

    public Class[] generates() {
        return new Class[]{SequencePlotterContainer.class};
    }

    public boolean hasPendingOutput() {
        return this.m_Containers.size() > 0;
    }

    public Token output() {
        Token result = new Token((Object)this.m_Containers.get(0));
        this.m_InputToken = null;
        this.m_Containers.remove(0);
        return result;
    }

    public static class SortableRow
    implements Comparable<SortableRow> {
        protected Comparable m_Index;
        protected SpreadSheet.Row m_Row;
        protected boolean m_InvertSorting;

        public SortableRow(Comparable index, SpreadSheet.Row row, boolean invSort) {
            this.m_Index = index;
            this.m_Row = row;
            this.m_InvertSorting = invSort;
        }

        public Comparable getIndex() {
            return this.m_Index;
        }

        public SpreadSheet.Row getRow() {
            return this.m_Row;
        }

        public boolean isInvertSorting() {
            return this.m_InvertSorting;
        }

        @Override
        public int compareTo(SortableRow o) {
            return this.getIndex().compareTo(o.getIndex()) * (this.m_InvertSorting ? -1 : 1);
        }

        public String toString() {
            return (this.m_InvertSorting ? "!" : "") + this.m_Index + ": " + this.m_Row;
        }
    }
}

