/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.DateFormat;
import adams.core.base.BaseObject;
import adams.parser.BaseDateExpression;
import adams.parser.GrammarSupplier;
import java.util.Date;

public class BaseDate
extends BaseObject
implements GrammarSupplier {
    private static final long serialVersionUID = -5853830144343397434L;
    public static final String INF_PAST = "-INF";
    public static final String INF_PAST_DATE = "0001-01-01";
    public static final String INF_FUTURE = "+INF";
    public static final String INF_FUTURE_DATE = "9999-12-31";
    public static final String NOW = "NOW";
    public static final String START = "START";
    public static final String END = "END";
    public static final String FORMAT = "yyyy-MM-dd";
    protected static DateFormat m_Format = new DateFormat("yyyy-MM-dd");
    protected Date m_Start = null;
    protected Date m_End = null;

    public BaseDate() {
        this(NOW);
    }

    public BaseDate(String s) {
        super(s);
    }

    public BaseDate(Date date) {
        this(m_Format.format(date));
    }

    public void setStart(Date value) {
        this.m_Start = value;
    }

    public Date getStart() {
        return this.m_Start;
    }

    public void setEnd(Date value) {
        this.m_End = value;
    }

    public Date getEnd() {
        return this.m_End;
    }

    protected Date parse(String s, boolean quiet) {
        try {
            return BaseDateExpression.evaluate(s, this.m_Start, this.m_End);
        }
        catch (Exception e) {
            if (!quiet) {
                System.err.println("Failed to parse: " + s);
                e.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public boolean isValid(String value) {
        if ((value = value.toUpperCase()).length() == 0) {
            return true;
        }
        return this.parse(value, true) != null;
    }

    @Override
    public void setValue(String value) {
        if (!this.isValid(value)) {
            return;
        }
        this.m_Internal = value.equals(INF_FUTURE_DATE) ? INF_FUTURE : (value.equals(INF_PAST_DATE) ? INF_PAST : (value.length() == 0 ? NOW : value));
    }

    @Override
    public String getValue() {
        return (String)((Object)this.m_Internal);
    }

    public Date dateValue() {
        return this.parse(this.getValue(), false);
    }

    public String stringValue() {
        return m_Format.format(this.dateValue());
    }

    @Override
    public String getTipText() {
        return "A date of format 'yyyy-MM-dd' ('-INF' = '0001-01-01', '+INF' = '9999-12-31', 'NOW' = the current date/time).";
    }

    @Override
    public String getGrammar() {
        return new BaseDateExpression().getGrammar();
    }

    public boolean isInfinityFuture() {
        return this.getValue().equals(INF_FUTURE);
    }

    public boolean isInfinityPast() {
        return this.getValue().equals(INF_PAST);
    }

    public boolean isInfinity() {
        return this.isInfinityPast() || this.isInfinityFuture();
    }

    public static BaseDate now() {
        return new BaseDate(NOW);
    }

    public static BaseDate infinityFuture() {
        return new BaseDate(INF_FUTURE);
    }

    public static BaseDate infinityPast() {
        return new BaseDate(INF_PAST);
    }
}

