/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.Utils;
import adams.core.io.AbstractSpreadSheetReader;
import adams.core.io.SpreadSheet;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Vector;

public class CsvSpreadSheetReader
extends AbstractSpreadSheetReader {
    private static final long serialVersionUID = 4461796269354230002L;

    @Override
    public String globalInfo() {
        return "Reads CSV files.";
    }

    @Override
    public String getFormatDescription() {
        return "CSV (comma-separated values)";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{"csv"};
    }

    @Override
    protected boolean getUseInputStream() {
        return false;
    }

    protected String unquote(String s) {
        String result = Utils.unquote(s);
        result = Utils.unDoubleQuote(result);
        return result;
    }

    protected String[] breakUp(String line) {
        Vector<String> result = new Vector<String>();
        StringBuffer current = new StringBuffer();
        boolean escaped = false;
        char escapeChr = '\u0000';
        for (int i = 0; i < line.length(); ++i) {
            char chr = line.charAt(i);
            if (chr == ',' || chr == '\t') {
                if (escaped) {
                    current.append(chr);
                    continue;
                }
                result.add(this.unquote(current.toString()));
                current = new StringBuffer();
                continue;
            }
            if (chr == '\'' || chr == '\"') {
                if (i > 0 && line.charAt(i - 1) == '\\') {
                    current.append(chr);
                    continue;
                }
                if (escaped && escapeChr == chr) {
                    escaped = false;
                    current.append(chr);
                    continue;
                }
                escaped = true;
                escapeChr = chr;
                current.append(chr);
                continue;
            }
            current.append(chr);
        }
        result.add(this.unquote(current.toString()));
        return result.toArray(new String[result.size()]);
    }

    @Override
    protected SpreadSheet doRead(Reader r) {
        SpreadSheet result;
        BufferedReader reader = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        try {
            String line;
            result = new SpreadSheet();
            boolean comments = true;
            String[] headerCells = null;
            while ((line = reader.readLine()) != null) {
                SpreadSheet.Row row;
                if (line.startsWith("#")) {
                    if (!comments) continue;
                    result.addComment(line.substring(1).trim());
                    continue;
                }
                comments = false;
                if (line.trim().length() == 0) continue;
                String[] cells = this.breakUp(line);
                if (headerCells == null) {
                    headerCells = cells;
                    row = result.getHeaderRow();
                } else {
                    row = result.addRow("" + result.getRowCount());
                }
                for (int i = 0; i < headerCells.length && i < cells.length; ++i) {
                    if (cells[i].equals(this.m_MissingValue)) {
                        row.addCell("" + i).setContent("?");
                        continue;
                    }
                    row.addCell("" + i).setContent(cells[i]);
                }
            }
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }
}

