/*
 * Decompiled with CFR 0.152.
 */
package adams.env;

import adams.core.Properties;
import adams.env.Environment;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;

public class Revisions {
    public static final String FILENAME = "Revisions.props";
    protected static Revisions m_Singleton;
    protected Properties m_Properties = Environment.getInstance().read("revisions");
    protected Hashtable<String, String> m_Revisions = new Hashtable();

    private Revisions() {
        Enumeration<?> enm = this.m_Properties.propertyNames();
        while (enm.hasMoreElements()) {
            String key = (String)enm.nextElement();
            String file = this.m_Properties.getProperty(key);
            try {
                InputStream in = ClassLoader.getSystemResourceAsStream(file);
                if (in != null) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    String line = reader.readLine();
                    String[] parts = line.split("=");
                    if (parts.length == 2) {
                        this.m_Revisions.put(parts[0], parts[1]);
                    }
                    reader.close();
                    continue;
                }
                System.err.println("Failed to load revision: " + file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Enumeration<String> names() {
        return this.m_Revisions.keys();
    }

    public String get(String name) {
        return this.m_Revisions.get(name);
    }

    public static synchronized Revisions getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new Revisions();
        }
        return m_Singleton;
    }
}

