/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.ClassLocator;
import adams.flow.core.EventReference;
import adams.flow.processor.AbstractNameUpdater;

public class UpdateEventName
extends AbstractNameUpdater<EventReference> {
    private static final long serialVersionUID = 7133896476260133469L;

    @Override
    public String globalInfo() {
        return "Updates all occurrences of the old event name with the new one.";
    }

    @Override
    public String oldNameTipText() {
        return "The old event name to replace with the new one.";
    }

    @Override
    public String newNameTipText() {
        return "The new event name that replaces the old one.";
    }

    @Override
    protected boolean isBaseClassMatch(Class cls) {
        return ClassLocator.isSubclass(EventReference.class, cls);
    }

    @Override
    protected boolean isNameMatch(EventReference old, String oldName) {
        return old.getValue().equals(oldName);
    }

    @Override
    protected EventReference getReplacement(EventReference old, String newName) {
        EventReference result;
        try {
            result = (EventReference)old.getClass().newInstance();
            result.setValue(newName);
        }
        catch (Exception e) {
            this.getSystemErr().println("Failed to create instance of " + old.getClass().getName() + ":");
            this.getSystemErr().printStackTrace(e);
            result = null;
        }
        return result;
    }
}

