/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.data.container.DataContainer;
import adams.flow.control.SubProcess;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.gui.scripting.AbstractDataContainerUpdatingScriptlet;
import adams.gui.visualization.container.Container;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.container.VisibilityContainerManager;
import java.util.Vector;

public abstract class AbstractFlowScriptlet
extends AbstractDataContainerUpdatingScriptlet {
    private static final long serialVersionUID = -2467186252442407554L;

    @Override
    protected String getOptionsDescription() {
        return "<filename>";
    }

    public String process(String options, boolean overlay) throws Exception {
        int i;
        Object manager = this.getDataContainerPanel().getContainerManager();
        if (((VisibilityContainerManager)manager).countVisible() == 0) {
            return "No visible chromatograms!";
        }
        String[] list = OptionUtils.splitOptions(options);
        if (list.length != 1) {
            return "Needs a single filename as parameter!";
        }
        Vector<String> errors = new Vector<String>();
        SubProcess actor = (SubProcess)ActorUtils.read(list[0], errors);
        if (!errors.isEmpty()) {
            return "Failed to load actor from '" + list[0] + "':\n" + Utils.flatten(errors, "\n");
        }
        if (actor == null) {
            return "Could not instantiate actor from '" + list[0] + "'!";
        }
        Class[] flowClasses = actor.accepts();
        String result = "Flow '" + list[0] + "' does not accept single chromatograms!";
        for (i = 0; i < flowClasses.length; ++i) {
            if (flowClasses[i] != this.getOwner().getRequiredFlowClass()) continue;
            result = null;
            break;
        }
        if (result != null) {
            return result;
        }
        flowClasses = actor.generates();
        result = "Flow '" + list[0] + "' does not generate single chromatograms!";
        for (i = 0; i < flowClasses.length; ++i) {
            if (flowClasses[i] != this.getOwner().getRequiredFlowClass()) continue;
            result = null;
            break;
        }
        if (result != null) {
            return result;
        }
        Vector<DataContainer> runInput = new Vector<DataContainer>();
        for (i = 0; i < ((ContainerManager)manager).count(); ++i) {
            if (!((VisibilityContainerManager)manager).isVisible(i)) continue;
            runInput.add((DataContainer)((Container)((ContainerManager)manager).get(i)).getPayload());
        }
        Vector<DataContainer> runOutput = new Vector<DataContainer>();
        for (i = 0; i < runInput.size(); ++i) {
            this.showStatus("Passing data through flow " + (i + 1) + "/" + ((VisibilityContainerManager)manager).countVisible());
            SubProcess runActor = (SubProcess)actor.shallowCopy(true);
            runActor.setUp();
            runActor.input(new Token(runInput.get(i)));
            result = runActor.execute();
            if (result == null) {
                runOutput.add((DataContainer)runActor.output().getPayload());
            }
            runActor.wrapUp();
            runActor.destroy();
            if (result != null) break;
        }
        actor.destroy();
        this.showStatus("");
        if (result != null) {
            return result;
        }
        this.addUndoPoint("Saving undo data...", "Flow: " + list[0]);
        this.updateDataContainers(runOutput, overlay);
        return null;
    }
}

