/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.http;

import twitter4j.conf.Configuration;
import twitter4j.http.AccessToken;
import twitter4j.http.Authorization;
import twitter4j.http.BasicAuthorization;
import twitter4j.http.NullAuthorization;
import twitter4j.http.OAuthAuthorization;

public final class AuthorizationFactory {
    public static Authorization getInstance(Configuration conf) {
        return AuthorizationFactory.getInstance(conf, true);
    }

    public static Authorization getInstance(Configuration conf, boolean supportsOAuth) {
        Authorization auth = null;
        String consumerKey = conf.getOAuthConsumerKey();
        String consumerSecret = conf.getOAuthConsumerSecret();
        if (supportsOAuth && null != consumerKey && null != consumerSecret) {
            OAuthAuthorization oauth = new OAuthAuthorization(conf, consumerKey, consumerSecret);
            String accessToken = conf.getOAuthAccessToken();
            String accessTokenSecret = conf.getOAuthAccessTokenSecret();
            if (null != accessToken && null != accessTokenSecret) {
                oauth.setOAuthAccessToken(new AccessToken(accessToken, accessTokenSecret));
            }
            auth = oauth;
        } else {
            String screenName = conf.getUser();
            String password = conf.getPassword();
            if (null != screenName && null != password) {
                auth = new BasicAuthorization(screenName, password);
            }
        }
        if (null == auth) {
            auth = NullAuthorization.getInstance();
        }
        return auth;
    }

    public static Authorization getBasicAuthorizationInstance(String screenName, String password) {
        return new BasicAuthorization(screenName, password);
    }
}

