/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.jna;

import com.sun.jna.CallbackProxy;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import de.intarsys.nativec.api.CLong;
import de.intarsys.nativec.api.CWideString;
import de.intarsys.nativec.api.ICallback;
import de.intarsys.nativec.api.INativeCallback;
import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.jna.JnaNativeHandle;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JnaNativeCallback
implements INativeCallback,
CallbackProxy {
    private ICallback callback;

    public static Class<?> translateType(Class<?> type) {
        if (CWideString.class.isAssignableFrom(type)) {
            return WString.class;
        }
        if (CLong.class.isAssignableFrom(type)) {
            return NativeLong.class;
        }
        if (NativeObject.class.isAssignableFrom(type)) {
            return Pointer.class;
        }
        if (INativeHandle.class.isAssignableFrom(type)) {
            return Pointer.class;
        }
        return type;
    }

    public JnaNativeCallback(ICallback pCallback) {
        this.callback = pCallback;
    }

    public Object callback(Object[] args) {
        int index = 0;
        while (index < args.length) {
            Pointer pointer;
            Object object;
            Class<?> parameterType = this.callback.getParameterTypes()[index];
            if (CWideString.class.isAssignableFrom(parameterType)) {
                WString wstring = (WString)args[index];
                object = new CWideString(wstring.toString());
            } else if (CLong.class.isAssignableFrom(parameterType)) {
                NativeLong nativeLong = (NativeLong)args[index];
                object = new CLong(nativeLong.longValue());
            } else if (NativeObject.class.isAssignableFrom(parameterType)) {
                pointer = (Pointer)args[index];
                if (pointer == null) {
                    object = null;
                } else {
                    JnaNativeHandle handle = new JnaNativeHandle(pointer);
                    INativeType type = NativeType.lookup(parameterType);
                    if (type == null) {
                        throw new IllegalArgumentException("no type for '" + parameterType + "'");
                    }
                    object = type.createNative(handle);
                }
            } else {
                object = INativeHandle.class.isAssignableFrom(parameterType) ? ((pointer = (Pointer)args[index]) == null ? null : new JnaNativeHandle(pointer)) : args[index];
            }
            args[index] = object;
            ++index;
        }
        return this.callback.invoke(args);
    }

    public Class<?>[] getParameterTypes() {
        Class<?>[] genericParameterTypes = this.callback.getParameterTypes();
        Class[] nativeParameterTypes = new Class[genericParameterTypes.length];
        int index = 0;
        while (index < genericParameterTypes.length) {
            nativeParameterTypes[index] = JnaNativeCallback.translateType(genericParameterTypes[index]);
            ++index;
        }
        return nativeParameterTypes;
    }

    public Class<?> getReturnType() {
        return JnaNativeCallback.translateType(this.callback.getReturnType());
    }
}

