/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.menu;

import adams.core.io.PlaceholderFile;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.ChildFrame;
import adams.gui.application.UserMode;
import adams.gui.menu.AbstractParameterHandlingWekaMenuItemDefinition;
import java.awt.Component;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;

public class TreeVisualizer
extends AbstractParameterHandlingWekaMenuItemDefinition {
    private static final long serialVersionUID = -771667287275117680L;
    protected JFileChooser m_FileChooser;

    public TreeVisualizer(AbstractApplicationFrame owner) {
        super(owner);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    }

    public void launch() {
        String filename;
        if (this.m_Parameters.length == 0) {
            int retVal = this.m_FileChooser.showOpenDialog((Component)this.getOwner());
            if (retVal != 0) {
                return;
            }
            filename = this.m_FileChooser.getSelectedFile().getAbsolutePath();
        } else {
            filename = new PlaceholderFile(this.m_Parameters[0]).getAbsolutePath();
        }
        TreeBuild builder = new TreeBuild();
        Node top = null;
        PlaceNode2 arrange = new PlaceNode2();
        try {
            top = builder.create((Reader)new FileReader(filename));
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog((Component)this.getOwner(), "Error loading file '" + filename + "':\n" + e.getMessage());
            return;
        }
        ChildFrame frame = this.createChildFrame((Component)new weka.gui.treevisualizer.TreeVisualizer(null, top, (NodePlace)arrange), 800, 600);
        frame.setTitle(frame.getTitle() + " - " + filename);
    }

    public String getTitle() {
        return "TreeVisualizer";
    }

    public boolean isSingleton() {
        return false;
    }

    public UserMode getUserMode() {
        return UserMode.BASIC;
    }
}

