/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.multisearch;

import java.io.Serializable;
import weka.classifiers.Evaluation;
import weka.classifiers.meta.MultiSearch;
import weka.core.SelectedTag;
import weka.core.setupgenerator.Point;

public class Performance
implements Serializable {
    private static final long serialVersionUID = -4374706475277588755L;
    public static final int EVALUATION_CC = 0;
    public static final int EVALUATION_RMSE = 1;
    public static final int EVALUATION_RRSE = 2;
    public static final int EVALUATION_MAE = 3;
    public static final int EVALUATION_RAE = 4;
    public static final int EVALUATION_COMBINED = 5;
    public static final int EVALUATION_ACC = 6;
    public static final int EVALUATION_KAPPA = 7;
    protected Point<Object> m_Values;
    protected int m_Evaluation;
    protected double m_CC;
    protected double m_RMSE;
    protected double m_RRSE;
    protected double m_MAE;
    protected double m_RAE;
    protected double m_ACC;
    protected double m_Kappa;

    public Performance(Point<Object> values, Evaluation evaluation, int evalType) throws Exception {
        this.m_Values = values;
        this.m_Evaluation = evalType;
        if (evaluation != null) {
            this.m_RMSE = evaluation.rootMeanSquaredError();
            this.m_RRSE = evaluation.rootRelativeSquaredError();
            this.m_MAE = evaluation.meanAbsoluteError();
            this.m_RAE = evaluation.relativeAbsoluteError();
            try {
                this.m_CC = evaluation.correlationCoefficient();
            }
            catch (Exception e) {
                this.m_CC = Double.NaN;
            }
            try {
                this.m_ACC = evaluation.pctCorrect();
            }
            catch (Exception e) {
                this.m_ACC = Double.NaN;
            }
            try {
                this.m_Kappa = evaluation.kappa();
            }
            catch (Exception e) {
                this.m_Kappa = Double.NaN;
            }
        } else {
            this.m_RMSE = Double.MAX_VALUE;
            this.m_RRSE = Double.MAX_VALUE;
            this.m_MAE = Double.MAX_VALUE;
            this.m_RAE = Double.MAX_VALUE;
            this.m_CC = Double.MIN_VALUE;
            this.m_ACC = Double.MIN_VALUE;
            this.m_Kappa = Double.MIN_VALUE;
        }
    }

    public int getEvaluation() {
        return this.m_Evaluation;
    }

    public double getPerformance() {
        return this.getPerformance(this.m_Evaluation);
    }

    public double getPerformance(int evaluation) {
        double result = Double.NaN;
        switch (evaluation) {
            case 0: {
                result = this.m_CC;
                break;
            }
            case 1: {
                result = this.m_RMSE;
                break;
            }
            case 2: {
                result = this.m_RRSE;
                break;
            }
            case 3: {
                result = this.m_MAE;
                break;
            }
            case 4: {
                result = this.m_RAE;
                break;
            }
            case 5: {
                result = 1.0 - StrictMath.abs(this.m_CC) + this.m_RRSE + this.m_RAE;
                break;
            }
            case 6: {
                result = this.m_ACC;
                break;
            }
            case 7: {
                result = this.m_Kappa;
                break;
            }
            default: {
                throw new IllegalArgumentException("Evaluation type '" + evaluation + "' not supported!");
            }
        }
        return result;
    }

    public Point<Object> getValues() {
        return this.m_Values;
    }

    public String toString() {
        String result = "Performance (" + this.getValues() + "): ";
        result = result + this.getPerformance() + " (" + new SelectedTag(this.m_Evaluation, MultiSearch.TAGS_EVALUATION) + ")";
        if (this.m_Evaluation == 5) {
            result = result + ", " + this.getPerformance(0) + " (" + new SelectedTag(0, MultiSearch.TAGS_EVALUATION) + ")";
            result = result + ", " + this.getPerformance(2) + " (" + new SelectedTag(2, MultiSearch.TAGS_EVALUATION) + ")";
            result = result + ", " + this.getPerformance(4) + " (" + new SelectedTag(4, MultiSearch.TAGS_EVALUATION) + ")";
        }
        return result;
    }
}

