/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.DateFormat;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.conversion.AbstractConversion;
import java.util.Date;

public class TimeToString
extends AbstractConversion
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 6744245717394758406L;
    protected String m_Format;
    protected transient DateFormat m_Formatter;

    @Override
    public String globalInfo() {
        return "Turns a number representing milli-seconds since 1970 (Java date) into a String.\nFor more information on formatting the date, see:\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        return new DateFormat().getTechnicalInformation();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("format", "format", "yyyy-MM-dd HH:mm:ss");
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Formatter = null;
    }

    public void setFormat(String value) {
        this.m_Format = value;
        this.reset();
    }

    public String getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The format to use for converting the time into a string.";
    }

    @Override
    public Class accepts() {
        return Number.class;
    }

    @Override
    public Class generates() {
        return String.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        if (this.m_Formatter == null) {
            this.m_Formatter = new DateFormat(this.m_Format);
        }
        return this.m_Formatter.format(new Date(((Number)this.m_Input).longValue()));
    }
}

